package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ConsumerData extends ConsumerData {

  private final String kind;

  private final Resource.Metadata metadata;

  private final String clusterId;

  private final String consumerGroupId;

  private final String consumerId;

  private final Optional<String> instanceId;

  private final String clientId;

  private final Resource.Relationship assignments;

  private AutoValue_ConsumerData(
      String kind,
      Resource.Metadata metadata,
      String clusterId,
      String consumerGroupId,
      String consumerId,
      Optional<String> instanceId,
      String clientId,
      Resource.Relationship assignments) {
    this.kind = kind;
    this.metadata = metadata;
    this.clusterId = clusterId;
    this.consumerGroupId = consumerGroupId;
    this.consumerId = consumerId;
    this.instanceId = instanceId;
    this.clientId = clientId;
    this.assignments = assignments;
  }

  @JsonProperty("kind")
  @Override
  public String getKind() {
    return kind;
  }

  @JsonProperty("metadata")
  @Override
  public Resource.Metadata getMetadata() {
    return metadata;
  }

  @JsonProperty("cluster_id")
  @Override
  public String getClusterId() {
    return clusterId;
  }

  @JsonProperty("consumer_group_id")
  @Override
  public String getConsumerGroupId() {
    return consumerGroupId;
  }

  @JsonProperty("consumer_id")
  @Override
  public String getConsumerId() {
    return consumerId;
  }

  @JsonProperty("instance_id")
  @Override
  public Optional<String> getInstanceId() {
    return instanceId;
  }

  @JsonProperty("client_id")
  @Override
  public String getClientId() {
    return clientId;
  }

  @JsonProperty("assignments")
  @Override
  public Resource.Relationship getAssignments() {
    return assignments;
  }

  @Override
  public String toString() {
    return "ConsumerData{"
        + "kind=" + kind + ", "
        + "metadata=" + metadata + ", "
        + "clusterId=" + clusterId + ", "
        + "consumerGroupId=" + consumerGroupId + ", "
        + "consumerId=" + consumerId + ", "
        + "instanceId=" + instanceId + ", "
        + "clientId=" + clientId + ", "
        + "assignments=" + assignments
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ConsumerData) {
      ConsumerData that = (ConsumerData) o;
      return this.kind.equals(that.getKind())
          && this.metadata.equals(that.getMetadata())
          && this.clusterId.equals(that.getClusterId())
          && this.consumerGroupId.equals(that.getConsumerGroupId())
          && this.consumerId.equals(that.getConsumerId())
          && this.instanceId.equals(that.getInstanceId())
          && this.clientId.equals(that.getClientId())
          && this.assignments.equals(that.getAssignments());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= kind.hashCode();
    h$ *= 1000003;
    h$ ^= metadata.hashCode();
    h$ *= 1000003;
    h$ ^= clusterId.hashCode();
    h$ *= 1000003;
    h$ ^= consumerGroupId.hashCode();
    h$ *= 1000003;
    h$ ^= consumerId.hashCode();
    h$ *= 1000003;
    h$ ^= instanceId.hashCode();
    h$ *= 1000003;
    h$ ^= clientId.hashCode();
    h$ *= 1000003;
    h$ ^= assignments.hashCode();
    return h$;
  }

  static final class Builder extends ConsumerData.Builder {
    private String kind;
    private Resource.Metadata metadata;
    private String clusterId;
    private String consumerGroupId;
    private String consumerId;
    private Optional<String> instanceId = Optional.empty();
    private String clientId;
    private Resource.Relationship assignments;
    Builder() {
    }
    @Override
    public ConsumerData.Builder setKind(String kind) {
      if (kind == null) {
        throw new NullPointerException("Null kind");
      }
      this.kind = kind;
      return this;
    }
    @Override
    public ConsumerData.Builder setMetadata(Resource.Metadata metadata) {
      if (metadata == null) {
        throw new NullPointerException("Null metadata");
      }
      this.metadata = metadata;
      return this;
    }
    @Override
    public ConsumerData.Builder setClusterId(String clusterId) {
      if (clusterId == null) {
        throw new NullPointerException("Null clusterId");
      }
      this.clusterId = clusterId;
      return this;
    }
    @Override
    public ConsumerData.Builder setConsumerGroupId(String consumerGroupId) {
      if (consumerGroupId == null) {
        throw new NullPointerException("Null consumerGroupId");
      }
      this.consumerGroupId = consumerGroupId;
      return this;
    }
    @Override
    public ConsumerData.Builder setConsumerId(String consumerId) {
      if (consumerId == null) {
        throw new NullPointerException("Null consumerId");
      }
      this.consumerId = consumerId;
      return this;
    }
    @Override
    public ConsumerData.Builder setInstanceId(@Nullable String instanceId) {
      this.instanceId = Optional.ofNullable(instanceId);
      return this;
    }
    @Override
    public ConsumerData.Builder setClientId(String clientId) {
      if (clientId == null) {
        throw new NullPointerException("Null clientId");
      }
      this.clientId = clientId;
      return this;
    }
    @Override
    public ConsumerData.Builder setAssignments(Resource.Relationship assignments) {
      if (assignments == null) {
        throw new NullPointerException("Null assignments");
      }
      this.assignments = assignments;
      return this;
    }
    @Override
    public ConsumerData build() {
      String missing = "";
      if (this.kind == null) {
        missing += " kind";
      }
      if (this.metadata == null) {
        missing += " metadata";
      }
      if (this.clusterId == null) {
        missing += " clusterId";
      }
      if (this.consumerGroupId == null) {
        missing += " consumerGroupId";
      }
      if (this.consumerId == null) {
        missing += " consumerId";
      }
      if (this.clientId == null) {
        missing += " clientId";
      }
      if (this.assignments == null) {
        missing += " assignments";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ConsumerData(
          this.kind,
          this.metadata,
          this.clusterId,
          this.consumerGroupId,
          this.consumerId,
          this.instanceId,
          this.clientId,
          this.assignments);
    }
  }

}
