package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ConsumerAssignmentData extends ConsumerAssignmentData {

  private final String kind;

  private final Resource.Metadata metadata;

  private final String clusterId;

  private final String consumerGroupId;

  private final String consumerId;

  private final String topicName;

  private final int partitionId;

  private final Resource.Relationship partition;

  private final Resource.Relationship lag;

  private AutoValue_ConsumerAssignmentData(
      String kind,
      Resource.Metadata metadata,
      String clusterId,
      String consumerGroupId,
      String consumerId,
      String topicName,
      int partitionId,
      Resource.Relationship partition,
      Resource.Relationship lag) {
    this.kind = kind;
    this.metadata = metadata;
    this.clusterId = clusterId;
    this.consumerGroupId = consumerGroupId;
    this.consumerId = consumerId;
    this.topicName = topicName;
    this.partitionId = partitionId;
    this.partition = partition;
    this.lag = lag;
  }

  @JsonProperty("kind")
  @Override
  public String getKind() {
    return kind;
  }

  @JsonProperty("metadata")
  @Override
  public Resource.Metadata getMetadata() {
    return metadata;
  }

  @JsonProperty("cluster_id")
  @Override
  public String getClusterId() {
    return clusterId;
  }

  @JsonProperty("consumer_group_id")
  @Override
  public String getConsumerGroupId() {
    return consumerGroupId;
  }

  @JsonProperty("consumer_id")
  @Override
  public String getConsumerId() {
    return consumerId;
  }

  @JsonProperty("topic_name")
  @Override
  public String getTopicName() {
    return topicName;
  }

  @JsonProperty("partition_id")
  @Override
  public int getPartitionId() {
    return partitionId;
  }

  @JsonProperty("partition")
  @Override
  public Resource.Relationship getPartition() {
    return partition;
  }

  @JsonProperty("lag")
  @Override
  public Resource.Relationship getLag() {
    return lag;
  }

  @Override
  public String toString() {
    return "ConsumerAssignmentData{"
        + "kind=" + kind + ", "
        + "metadata=" + metadata + ", "
        + "clusterId=" + clusterId + ", "
        + "consumerGroupId=" + consumerGroupId + ", "
        + "consumerId=" + consumerId + ", "
        + "topicName=" + topicName + ", "
        + "partitionId=" + partitionId + ", "
        + "partition=" + partition + ", "
        + "lag=" + lag
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ConsumerAssignmentData) {
      ConsumerAssignmentData that = (ConsumerAssignmentData) o;
      return this.kind.equals(that.getKind())
          && this.metadata.equals(that.getMetadata())
          && this.clusterId.equals(that.getClusterId())
          && this.consumerGroupId.equals(that.getConsumerGroupId())
          && this.consumerId.equals(that.getConsumerId())
          && this.topicName.equals(that.getTopicName())
          && this.partitionId == that.getPartitionId()
          && this.partition.equals(that.getPartition())
          && this.lag.equals(that.getLag());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= kind.hashCode();
    h$ *= 1000003;
    h$ ^= metadata.hashCode();
    h$ *= 1000003;
    h$ ^= clusterId.hashCode();
    h$ *= 1000003;
    h$ ^= consumerGroupId.hashCode();
    h$ *= 1000003;
    h$ ^= consumerId.hashCode();
    h$ *= 1000003;
    h$ ^= topicName.hashCode();
    h$ *= 1000003;
    h$ ^= partitionId;
    h$ *= 1000003;
    h$ ^= partition.hashCode();
    h$ *= 1000003;
    h$ ^= lag.hashCode();
    return h$;
  }

  static final class Builder extends ConsumerAssignmentData.Builder {
    private String kind;
    private Resource.Metadata metadata;
    private String clusterId;
    private String consumerGroupId;
    private String consumerId;
    private String topicName;
    private Integer partitionId;
    private Resource.Relationship partition;
    private Resource.Relationship lag;
    Builder() {
    }
    @Override
    public ConsumerAssignmentData.Builder setKind(String kind) {
      if (kind == null) {
        throw new NullPointerException("Null kind");
      }
      this.kind = kind;
      return this;
    }
    @Override
    public ConsumerAssignmentData.Builder setMetadata(Resource.Metadata metadata) {
      if (metadata == null) {
        throw new NullPointerException("Null metadata");
      }
      this.metadata = metadata;
      return this;
    }
    @Override
    public ConsumerAssignmentData.Builder setClusterId(String clusterId) {
      if (clusterId == null) {
        throw new NullPointerException("Null clusterId");
      }
      this.clusterId = clusterId;
      return this;
    }
    @Override
    public ConsumerAssignmentData.Builder setConsumerGroupId(String consumerGroupId) {
      if (consumerGroupId == null) {
        throw new NullPointerException("Null consumerGroupId");
      }
      this.consumerGroupId = consumerGroupId;
      return this;
    }
    @Override
    public ConsumerAssignmentData.Builder setConsumerId(String consumerId) {
      if (consumerId == null) {
        throw new NullPointerException("Null consumerId");
      }
      this.consumerId = consumerId;
      return this;
    }
    @Override
    public ConsumerAssignmentData.Builder setTopicName(String topicName) {
      if (topicName == null) {
        throw new NullPointerException("Null topicName");
      }
      this.topicName = topicName;
      return this;
    }
    @Override
    public ConsumerAssignmentData.Builder setPartitionId(int partitionId) {
      this.partitionId = partitionId;
      return this;
    }
    @Override
    public ConsumerAssignmentData.Builder setPartition(Resource.Relationship partition) {
      if (partition == null) {
        throw new NullPointerException("Null partition");
      }
      this.partition = partition;
      return this;
    }
    @Override
    public ConsumerAssignmentData.Builder setLag(Resource.Relationship lag) {
      if (lag == null) {
        throw new NullPointerException("Null lag");
      }
      this.lag = lag;
      return this;
    }
    @Override
    public ConsumerAssignmentData build() {
      String missing = "";
      if (this.kind == null) {
        missing += " kind";
      }
      if (this.metadata == null) {
        missing += " metadata";
      }
      if (this.clusterId == null) {
        missing += " clusterId";
      }
      if (this.consumerGroupId == null) {
        missing += " consumerGroupId";
      }
      if (this.consumerId == null) {
        missing += " consumerId";
      }
      if (this.topicName == null) {
        missing += " topicName";
      }
      if (this.partitionId == null) {
        missing += " partitionId";
      }
      if (this.partition == null) {
        missing += " partition";
      }
      if (this.lag == null) {
        missing += " lag";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ConsumerAssignmentData(
          this.kind,
          this.metadata,
          this.clusterId,
          this.consumerGroupId,
          this.consumerId,
          this.topicName,
          this.partitionId,
          this.partition,
          this.lag);
    }
  }

}
