package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.ConfigSource;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ConfigSynonymData extends ConfigSynonymData {

  private final String name;

  private final Optional<String> value;

  private final ConfigSource source;

  private AutoValue_ConfigSynonymData(
      String name,
      Optional<String> value,
      ConfigSource source) {
    this.name = name;
    this.value = value;
    this.source = source;
  }

  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  @JsonProperty("value")
  @Override
  public Optional<String> getValue() {
    return value;
  }

  @JsonProperty("source")
  @Override
  public ConfigSource getSource() {
    return source;
  }

  @Override
  public String toString() {
    return "ConfigSynonymData{"
        + "name=" + name + ", "
        + "value=" + value + ", "
        + "source=" + source
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ConfigSynonymData) {
      ConfigSynonymData that = (ConfigSynonymData) o;
      return this.name.equals(that.getName())
          && this.value.equals(that.getValue())
          && this.source.equals(that.getSource());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= value.hashCode();
    h$ *= 1000003;
    h$ ^= source.hashCode();
    return h$;
  }

  static final class Builder extends ConfigSynonymData.Builder {
    private String name;
    private Optional<String> value = Optional.empty();
    private ConfigSource source;
    Builder() {
    }
    @Override
    public ConfigSynonymData.Builder setName(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public ConfigSynonymData.Builder setValue(@Nullable String value) {
      this.value = Optional.ofNullable(value);
      return this;
    }
    @Override
    public ConfigSynonymData.Builder setSource(ConfigSource source) {
      if (source == null) {
        throw new NullPointerException("Null source");
      }
      this.source = source;
      return this;
    }
    @Override
    public ConfigSynonymData build() {
      String missing = "";
      if (this.name == null) {
        missing += " name";
      }
      if (this.source == null) {
        missing += " source";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ConfigSynonymData(
          this.name,
          this.value,
          this.source);
    }
  }

}
