package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ClusterData extends ClusterData {

  private final String kind;

  private final Resource.Metadata metadata;

  private final String clusterId;

  private final Optional<Resource.Relationship> controller;

  private final Resource.Relationship acls;

  private final Resource.Relationship brokers;

  private final Resource.Relationship brokerConfigs;

  private final Resource.Relationship consumerGroups;

  private final Resource.Relationship topics;

  private final Resource.Relationship partitionReassignments;

  private AutoValue_ClusterData(
      String kind,
      Resource.Metadata metadata,
      String clusterId,
      Optional<Resource.Relationship> controller,
      Resource.Relationship acls,
      Resource.Relationship brokers,
      Resource.Relationship brokerConfigs,
      Resource.Relationship consumerGroups,
      Resource.Relationship topics,
      Resource.Relationship partitionReassignments) {
    this.kind = kind;
    this.metadata = metadata;
    this.clusterId = clusterId;
    this.controller = controller;
    this.acls = acls;
    this.brokers = brokers;
    this.brokerConfigs = brokerConfigs;
    this.consumerGroups = consumerGroups;
    this.topics = topics;
    this.partitionReassignments = partitionReassignments;
  }

  @JsonProperty("kind")
  @Override
  public String getKind() {
    return kind;
  }

  @JsonProperty("metadata")
  @Override
  public Resource.Metadata getMetadata() {
    return metadata;
  }

  @JsonProperty("cluster_id")
  @Override
  public String getClusterId() {
    return clusterId;
  }

  @JsonProperty("controller")
  @Override
  public Optional<Resource.Relationship> getController() {
    return controller;
  }

  @JsonProperty("acls")
  @Override
  public Resource.Relationship getAcls() {
    return acls;
  }

  @JsonProperty("brokers")
  @Override
  public Resource.Relationship getBrokers() {
    return brokers;
  }

  @JsonProperty("broker_configs")
  @Override
  public Resource.Relationship getBrokerConfigs() {
    return brokerConfigs;
  }

  @JsonProperty("consumer_groups")
  @Override
  public Resource.Relationship getConsumerGroups() {
    return consumerGroups;
  }

  @JsonProperty("topics")
  @Override
  public Resource.Relationship getTopics() {
    return topics;
  }

  @JsonProperty("partition_reassignments")
  @Override
  public Resource.Relationship getPartitionReassignments() {
    return partitionReassignments;
  }

  @Override
  public String toString() {
    return "ClusterData{"
        + "kind=" + kind + ", "
        + "metadata=" + metadata + ", "
        + "clusterId=" + clusterId + ", "
        + "controller=" + controller + ", "
        + "acls=" + acls + ", "
        + "brokers=" + brokers + ", "
        + "brokerConfigs=" + brokerConfigs + ", "
        + "consumerGroups=" + consumerGroups + ", "
        + "topics=" + topics + ", "
        + "partitionReassignments=" + partitionReassignments
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ClusterData) {
      ClusterData that = (ClusterData) o;
      return this.kind.equals(that.getKind())
          && this.metadata.equals(that.getMetadata())
          && this.clusterId.equals(that.getClusterId())
          && this.controller.equals(that.getController())
          && this.acls.equals(that.getAcls())
          && this.brokers.equals(that.getBrokers())
          && this.brokerConfigs.equals(that.getBrokerConfigs())
          && this.consumerGroups.equals(that.getConsumerGroups())
          && this.topics.equals(that.getTopics())
          && this.partitionReassignments.equals(that.getPartitionReassignments());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= kind.hashCode();
    h$ *= 1000003;
    h$ ^= metadata.hashCode();
    h$ *= 1000003;
    h$ ^= clusterId.hashCode();
    h$ *= 1000003;
    h$ ^= controller.hashCode();
    h$ *= 1000003;
    h$ ^= acls.hashCode();
    h$ *= 1000003;
    h$ ^= brokers.hashCode();
    h$ *= 1000003;
    h$ ^= brokerConfigs.hashCode();
    h$ *= 1000003;
    h$ ^= consumerGroups.hashCode();
    h$ *= 1000003;
    h$ ^= topics.hashCode();
    h$ *= 1000003;
    h$ ^= partitionReassignments.hashCode();
    return h$;
  }

  static final class Builder extends ClusterData.Builder {
    private String kind;
    private Resource.Metadata metadata;
    private String clusterId;
    private Optional<Resource.Relationship> controller = Optional.empty();
    private Resource.Relationship acls;
    private Resource.Relationship brokers;
    private Resource.Relationship brokerConfigs;
    private Resource.Relationship consumerGroups;
    private Resource.Relationship topics;
    private Resource.Relationship partitionReassignments;
    Builder() {
    }
    @Override
    public ClusterData.Builder setKind(String kind) {
      if (kind == null) {
        throw new NullPointerException("Null kind");
      }
      this.kind = kind;
      return this;
    }
    @Override
    public ClusterData.Builder setMetadata(Resource.Metadata metadata) {
      if (metadata == null) {
        throw new NullPointerException("Null metadata");
      }
      this.metadata = metadata;
      return this;
    }
    @Override
    public ClusterData.Builder setClusterId(String clusterId) {
      if (clusterId == null) {
        throw new NullPointerException("Null clusterId");
      }
      this.clusterId = clusterId;
      return this;
    }
    @Override
    public ClusterData.Builder setController(@Nullable Resource.Relationship controller) {
      this.controller = Optional.ofNullable(controller);
      return this;
    }
    @Override
    public ClusterData.Builder setAcls(Resource.Relationship acls) {
      if (acls == null) {
        throw new NullPointerException("Null acls");
      }
      this.acls = acls;
      return this;
    }
    @Override
    public ClusterData.Builder setBrokers(Resource.Relationship brokers) {
      if (brokers == null) {
        throw new NullPointerException("Null brokers");
      }
      this.brokers = brokers;
      return this;
    }
    @Override
    public ClusterData.Builder setBrokerConfigs(Resource.Relationship brokerConfigs) {
      if (brokerConfigs == null) {
        throw new NullPointerException("Null brokerConfigs");
      }
      this.brokerConfigs = brokerConfigs;
      return this;
    }
    @Override
    public ClusterData.Builder setConsumerGroups(Resource.Relationship consumerGroups) {
      if (consumerGroups == null) {
        throw new NullPointerException("Null consumerGroups");
      }
      this.consumerGroups = consumerGroups;
      return this;
    }
    @Override
    public ClusterData.Builder setTopics(Resource.Relationship topics) {
      if (topics == null) {
        throw new NullPointerException("Null topics");
      }
      this.topics = topics;
      return this;
    }
    @Override
    public ClusterData.Builder setPartitionReassignments(Resource.Relationship partitionReassignments) {
      if (partitionReassignments == null) {
        throw new NullPointerException("Null partitionReassignments");
      }
      this.partitionReassignments = partitionReassignments;
      return this;
    }
    @Override
    public ClusterData build() {
      String missing = "";
      if (this.kind == null) {
        missing += " kind";
      }
      if (this.metadata == null) {
        missing += " metadata";
      }
      if (this.clusterId == null) {
        missing += " clusterId";
      }
      if (this.acls == null) {
        missing += " acls";
      }
      if (this.brokers == null) {
        missing += " brokers";
      }
      if (this.brokerConfigs == null) {
        missing += " brokerConfigs";
      }
      if (this.consumerGroups == null) {
        missing += " consumerGroups";
      }
      if (this.topics == null) {
        missing += " topics";
      }
      if (this.partitionReassignments == null) {
        missing += " partitionReassignments";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ClusterData(
          this.kind,
          this.metadata,
          this.clusterId,
          this.controller,
          this.acls,
          this.brokers,
          this.brokerConfigs,
          this.consumerGroups,
          this.topics,
          this.partitionReassignments);
    }
  }

}
