package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.ClusterConfig;
import io.confluent.kafkarest.entities.ConfigSource;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ClusterConfigData extends ClusterConfigData {

  private final String kind;

  private final Resource.Metadata metadata;

  private final String clusterId;

  private final String name;

  private final Optional<String> value;

  private final boolean default0;

  private final boolean readOnly;

  private final boolean sensitive;

  private final ConfigSource source;

  private final ImmutableList<ConfigSynonymData> synonyms;

  private final ClusterConfig.Type configType;

  private AutoValue_ClusterConfigData(
      String kind,
      Resource.Metadata metadata,
      String clusterId,
      String name,
      Optional<String> value,
      boolean default0,
      boolean readOnly,
      boolean sensitive,
      ConfigSource source,
      ImmutableList<ConfigSynonymData> synonyms,
      ClusterConfig.Type configType) {
    this.kind = kind;
    this.metadata = metadata;
    this.clusterId = clusterId;
    this.name = name;
    this.value = value;
    this.default0 = default0;
    this.readOnly = readOnly;
    this.sensitive = sensitive;
    this.source = source;
    this.synonyms = synonyms;
    this.configType = configType;
  }

  @JsonProperty("kind")
  @Override
  public String getKind() {
    return kind;
  }

  @JsonProperty("metadata")
  @Override
  public Resource.Metadata getMetadata() {
    return metadata;
  }

  @JsonProperty("cluster_id")
  @Override
  public String getClusterId() {
    return clusterId;
  }

  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  @JsonProperty("value")
  @Override
  public Optional<String> getValue() {
    return value;
  }

  @JsonProperty("is_default")
  @Override
  public boolean isDefault() {
    return default0;
  }

  @JsonProperty("is_read_only")
  @Override
  public boolean isReadOnly() {
    return readOnly;
  }

  @JsonProperty("is_sensitive")
  @Override
  public boolean isSensitive() {
    return sensitive;
  }

  @JsonProperty("source")
  @Override
  public ConfigSource getSource() {
    return source;
  }

  @JsonProperty("synonyms")
  @Override
  public ImmutableList<ConfigSynonymData> getSynonyms() {
    return synonyms;
  }

  @JsonProperty("config_type")
  @Override
  public ClusterConfig.Type getConfigType() {
    return configType;
  }

  @Override
  public String toString() {
    return "ClusterConfigData{"
        + "kind=" + kind + ", "
        + "metadata=" + metadata + ", "
        + "clusterId=" + clusterId + ", "
        + "name=" + name + ", "
        + "value=" + value + ", "
        + "default=" + default0 + ", "
        + "readOnly=" + readOnly + ", "
        + "sensitive=" + sensitive + ", "
        + "source=" + source + ", "
        + "synonyms=" + synonyms + ", "
        + "configType=" + configType
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ClusterConfigData) {
      ClusterConfigData that = (ClusterConfigData) o;
      return this.kind.equals(that.getKind())
          && this.metadata.equals(that.getMetadata())
          && this.clusterId.equals(that.getClusterId())
          && this.name.equals(that.getName())
          && this.value.equals(that.getValue())
          && this.default0 == that.isDefault()
          && this.readOnly == that.isReadOnly()
          && this.sensitive == that.isSensitive()
          && this.source.equals(that.getSource())
          && this.synonyms.equals(that.getSynonyms())
          && this.configType.equals(that.getConfigType());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= kind.hashCode();
    h$ *= 1000003;
    h$ ^= metadata.hashCode();
    h$ *= 1000003;
    h$ ^= clusterId.hashCode();
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= value.hashCode();
    h$ *= 1000003;
    h$ ^= default0 ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= readOnly ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= sensitive ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= source.hashCode();
    h$ *= 1000003;
    h$ ^= synonyms.hashCode();
    h$ *= 1000003;
    h$ ^= configType.hashCode();
    return h$;
  }

  static final class Builder extends ClusterConfigData.Builder {
    private String kind;
    private Resource.Metadata metadata;
    private String clusterId;
    private String name;
    private Optional<String> value = Optional.empty();
    private Boolean default0;
    private Boolean readOnly;
    private Boolean sensitive;
    private ConfigSource source;
    private ImmutableList<ConfigSynonymData> synonyms;
    private ClusterConfig.Type configType;
    Builder() {
    }
    @Override
    public ClusterConfigData.Builder setKind(String kind) {
      if (kind == null) {
        throw new NullPointerException("Null kind");
      }
      this.kind = kind;
      return this;
    }
    @Override
    public ClusterConfigData.Builder setMetadata(Resource.Metadata metadata) {
      if (metadata == null) {
        throw new NullPointerException("Null metadata");
      }
      this.metadata = metadata;
      return this;
    }
    @Override
    public ClusterConfigData.Builder setClusterId(String clusterId) {
      if (clusterId == null) {
        throw new NullPointerException("Null clusterId");
      }
      this.clusterId = clusterId;
      return this;
    }
    @Override
    public ClusterConfigData.Builder setName(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public ClusterConfigData.Builder setValue(@Nullable String value) {
      this.value = Optional.ofNullable(value);
      return this;
    }
    @Override
    public ClusterConfigData.Builder setDefault(boolean default0) {
      this.default0 = default0;
      return this;
    }
    @Override
    public ClusterConfigData.Builder setReadOnly(boolean readOnly) {
      this.readOnly = readOnly;
      return this;
    }
    @Override
    public ClusterConfigData.Builder setSensitive(boolean sensitive) {
      this.sensitive = sensitive;
      return this;
    }
    @Override
    public ClusterConfigData.Builder setSource(ConfigSource source) {
      if (source == null) {
        throw new NullPointerException("Null source");
      }
      this.source = source;
      return this;
    }
    @Override
    public ClusterConfigData.Builder setSynonyms(List<ConfigSynonymData> synonyms) {
      this.synonyms = ImmutableList.copyOf(synonyms);
      return this;
    }
    @Override
    public ClusterConfigData.Builder setConfigType(ClusterConfig.Type configType) {
      if (configType == null) {
        throw new NullPointerException("Null configType");
      }
      this.configType = configType;
      return this;
    }
    @Override
    public ClusterConfigData build() {
      String missing = "";
      if (this.kind == null) {
        missing += " kind";
      }
      if (this.metadata == null) {
        missing += " metadata";
      }
      if (this.clusterId == null) {
        missing += " clusterId";
      }
      if (this.name == null) {
        missing += " name";
      }
      if (this.default0 == null) {
        missing += " default";
      }
      if (this.readOnly == null) {
        missing += " readOnly";
      }
      if (this.sensitive == null) {
        missing += " sensitive";
      }
      if (this.source == null) {
        missing += " source";
      }
      if (this.synonyms == null) {
        missing += " synonyms";
      }
      if (this.configType == null) {
        missing += " configType";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ClusterConfigData(
          this.kind,
          this.metadata,
          this.clusterId,
          this.name,
          this.value,
          this.default0,
          this.readOnly,
          this.sensitive,
          this.source,
          this.synonyms,
          this.configType);
    }
  }

}
