package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_BrokerData extends BrokerData {

  private final String kind;

  private final Resource.Metadata metadata;

  private final String clusterId;

  private final int brokerId;

  private final Optional<String> host;

  private final Optional<Integer> port;

  private final Optional<String> rack;

  private final Resource.Relationship configs;

  private final Resource.Relationship partitionReplicas;

  private AutoValue_BrokerData(
      String kind,
      Resource.Metadata metadata,
      String clusterId,
      int brokerId,
      Optional<String> host,
      Optional<Integer> port,
      Optional<String> rack,
      Resource.Relationship configs,
      Resource.Relationship partitionReplicas) {
    this.kind = kind;
    this.metadata = metadata;
    this.clusterId = clusterId;
    this.brokerId = brokerId;
    this.host = host;
    this.port = port;
    this.rack = rack;
    this.configs = configs;
    this.partitionReplicas = partitionReplicas;
  }

  @JsonProperty("kind")
  @Override
  public String getKind() {
    return kind;
  }

  @JsonProperty("metadata")
  @Override
  public Resource.Metadata getMetadata() {
    return metadata;
  }

  @JsonProperty("cluster_id")
  @Override
  public String getClusterId() {
    return clusterId;
  }

  @JsonProperty("broker_id")
  @Override
  public int getBrokerId() {
    return brokerId;
  }

  @JsonProperty("host")
  @Override
  public Optional<String> getHost() {
    return host;
  }

  @JsonProperty("port")
  @Override
  public Optional<Integer> getPort() {
    return port;
  }

  @JsonProperty("rack")
  @Override
  public Optional<String> getRack() {
    return rack;
  }

  @JsonProperty("configs")
  @Override
  public Resource.Relationship getConfigs() {
    return configs;
  }

  @JsonProperty("partition_replicas")
  @Override
  public Resource.Relationship getPartitionReplicas() {
    return partitionReplicas;
  }

  @Override
  public String toString() {
    return "BrokerData{"
        + "kind=" + kind + ", "
        + "metadata=" + metadata + ", "
        + "clusterId=" + clusterId + ", "
        + "brokerId=" + brokerId + ", "
        + "host=" + host + ", "
        + "port=" + port + ", "
        + "rack=" + rack + ", "
        + "configs=" + configs + ", "
        + "partitionReplicas=" + partitionReplicas
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof BrokerData) {
      BrokerData that = (BrokerData) o;
      return this.kind.equals(that.getKind())
          && this.metadata.equals(that.getMetadata())
          && this.clusterId.equals(that.getClusterId())
          && this.brokerId == that.getBrokerId()
          && this.host.equals(that.getHost())
          && this.port.equals(that.getPort())
          && this.rack.equals(that.getRack())
          && this.configs.equals(that.getConfigs())
          && this.partitionReplicas.equals(that.getPartitionReplicas());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= kind.hashCode();
    h$ *= 1000003;
    h$ ^= metadata.hashCode();
    h$ *= 1000003;
    h$ ^= clusterId.hashCode();
    h$ *= 1000003;
    h$ ^= brokerId;
    h$ *= 1000003;
    h$ ^= host.hashCode();
    h$ *= 1000003;
    h$ ^= port.hashCode();
    h$ *= 1000003;
    h$ ^= rack.hashCode();
    h$ *= 1000003;
    h$ ^= configs.hashCode();
    h$ *= 1000003;
    h$ ^= partitionReplicas.hashCode();
    return h$;
  }

  static final class Builder extends BrokerData.Builder {
    private String kind;
    private Resource.Metadata metadata;
    private String clusterId;
    private Integer brokerId;
    private Optional<String> host = Optional.empty();
    private Optional<Integer> port = Optional.empty();
    private Optional<String> rack = Optional.empty();
    private Resource.Relationship configs;
    private Resource.Relationship partitionReplicas;
    Builder() {
    }
    @Override
    public BrokerData.Builder setKind(String kind) {
      if (kind == null) {
        throw new NullPointerException("Null kind");
      }
      this.kind = kind;
      return this;
    }
    @Override
    public BrokerData.Builder setMetadata(Resource.Metadata metadata) {
      if (metadata == null) {
        throw new NullPointerException("Null metadata");
      }
      this.metadata = metadata;
      return this;
    }
    @Override
    public BrokerData.Builder setClusterId(String clusterId) {
      if (clusterId == null) {
        throw new NullPointerException("Null clusterId");
      }
      this.clusterId = clusterId;
      return this;
    }
    @Override
    public BrokerData.Builder setBrokerId(int brokerId) {
      this.brokerId = brokerId;
      return this;
    }
    @Override
    public BrokerData.Builder setHost(@Nullable String host) {
      this.host = Optional.ofNullable(host);
      return this;
    }
    @Override
    public BrokerData.Builder setPort(@Nullable Integer port) {
      this.port = Optional.ofNullable(port);
      return this;
    }
    @Override
    public BrokerData.Builder setRack(@Nullable String rack) {
      this.rack = Optional.ofNullable(rack);
      return this;
    }
    @Override
    public BrokerData.Builder setConfigs(Resource.Relationship configs) {
      if (configs == null) {
        throw new NullPointerException("Null configs");
      }
      this.configs = configs;
      return this;
    }
    @Override
    public BrokerData.Builder setPartitionReplicas(Resource.Relationship partitionReplicas) {
      if (partitionReplicas == null) {
        throw new NullPointerException("Null partitionReplicas");
      }
      this.partitionReplicas = partitionReplicas;
      return this;
    }
    @Override
    public BrokerData build() {
      String missing = "";
      if (this.kind == null) {
        missing += " kind";
      }
      if (this.metadata == null) {
        missing += " metadata";
      }
      if (this.clusterId == null) {
        missing += " clusterId";
      }
      if (this.brokerId == null) {
        missing += " brokerId";
      }
      if (this.configs == null) {
        missing += " configs";
      }
      if (this.partitionReplicas == null) {
        missing += " partitionReplicas";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_BrokerData(
          this.kind,
          this.metadata,
          this.clusterId,
          this.brokerId,
          this.host,
          this.port,
          this.rack,
          this.configs,
          this.partitionReplicas);
    }
  }

}
