package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_BrokerConfigDataList extends BrokerConfigDataList {

  private final String kind;

  private final ResourceCollection.Metadata metadata;

  private final ImmutableList<BrokerConfigData> data;

  private AutoValue_BrokerConfigDataList(
      String kind,
      ResourceCollection.Metadata metadata,
      ImmutableList<BrokerConfigData> data) {
    this.kind = kind;
    this.metadata = metadata;
    this.data = data;
  }

  @JsonProperty("kind")
  @Override
  public String getKind() {
    return kind;
  }

  @JsonProperty("metadata")
  @Override
  public ResourceCollection.Metadata getMetadata() {
    return metadata;
  }

  @JsonProperty("data")
  @Override
  public ImmutableList<BrokerConfigData> getData() {
    return data;
  }

  @Override
  public String toString() {
    return "BrokerConfigDataList{"
        + "kind=" + kind + ", "
        + "metadata=" + metadata + ", "
        + "data=" + data
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof BrokerConfigDataList) {
      BrokerConfigDataList that = (BrokerConfigDataList) o;
      return this.kind.equals(that.getKind())
          && this.metadata.equals(that.getMetadata())
          && this.data.equals(that.getData());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= kind.hashCode();
    h$ *= 1000003;
    h$ ^= metadata.hashCode();
    h$ *= 1000003;
    h$ ^= data.hashCode();
    return h$;
  }

  static final class Builder extends BrokerConfigDataList.Builder {
    private String kind;
    private ResourceCollection.Metadata metadata;
    private ImmutableList<BrokerConfigData> data;
    Builder() {
    }
    @Override
    public BrokerConfigDataList.Builder setKind(String kind) {
      if (kind == null) {
        throw new NullPointerException("Null kind");
      }
      this.kind = kind;
      return this;
    }
    @Override
    public BrokerConfigDataList.Builder setMetadata(ResourceCollection.Metadata metadata) {
      if (metadata == null) {
        throw new NullPointerException("Null metadata");
      }
      this.metadata = metadata;
      return this;
    }
    @Override
    public BrokerConfigDataList.Builder setData(List<BrokerConfigData> data) {
      this.data = ImmutableList.copyOf(data);
      return this;
    }
    @Override
    public BrokerConfigDataList build() {
      String missing = "";
      if (this.kind == null) {
        missing += " kind";
      }
      if (this.metadata == null) {
        missing += " metadata";
      }
      if (this.data == null) {
        missing += " data";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_BrokerConfigDataList(
          this.kind,
          this.metadata,
          this.data);
    }
  }

}
