package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AlterConfigBatchRequestData_AlterEntry extends AlterConfigBatchRequestData.AlterEntry {

  private final String name;

  private final Optional<String> value;

  private final AlterConfigBatchRequestData.AlterOperation operation;

  private AutoValue_AlterConfigBatchRequestData_AlterEntry(
      String name,
      Optional<String> value,
      AlterConfigBatchRequestData.AlterOperation operation) {
    this.name = name;
    this.value = value;
    this.operation = operation;
  }

  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  @JsonProperty("value")
  @Override
  public Optional<String> getValue() {
    return value;
  }

  @JsonProperty("operation")
  @Override
  public AlterConfigBatchRequestData.AlterOperation getOperation() {
    return operation;
  }

  @Override
  public String toString() {
    return "AlterEntry{"
        + "name=" + name + ", "
        + "value=" + value + ", "
        + "operation=" + operation
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AlterConfigBatchRequestData.AlterEntry) {
      AlterConfigBatchRequestData.AlterEntry that = (AlterConfigBatchRequestData.AlterEntry) o;
      return this.name.equals(that.getName())
          && this.value.equals(that.getValue())
          && this.operation.equals(that.getOperation());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= value.hashCode();
    h$ *= 1000003;
    h$ ^= operation.hashCode();
    return h$;
  }

  static final class Builder extends AlterConfigBatchRequestData.AlterEntry.Builder {
    private String name;
    private Optional<String> value = Optional.empty();
    private AlterConfigBatchRequestData.AlterOperation operation;
    Builder() {
    }
    @Override
    public AlterConfigBatchRequestData.AlterEntry.Builder setName(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public AlterConfigBatchRequestData.AlterEntry.Builder setValue(@Nullable String value) {
      this.value = Optional.ofNullable(value);
      return this;
    }
    @Override
    public AlterConfigBatchRequestData.AlterEntry.Builder setOperation(AlterConfigBatchRequestData.AlterOperation operation) {
      if (operation == null) {
        throw new NullPointerException("Null operation");
      }
      this.operation = operation;
      return this;
    }
    @Override
    public AlterConfigBatchRequestData.AlterEntry build() {
      String missing = "";
      if (this.name == null) {
        missing += " name";
      }
      if (this.operation == null) {
        missing += " operation";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AlterConfigBatchRequestData_AlterEntry(
          this.name,
          this.value,
          this.operation);
    }
  }

}
