package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AclDataList extends AclDataList {

  private final String kind;

  private final ResourceCollection.Metadata metadata;

  private final ImmutableList<AclData> data;

  private AutoValue_AclDataList(
      String kind,
      ResourceCollection.Metadata metadata,
      ImmutableList<AclData> data) {
    this.kind = kind;
    this.metadata = metadata;
    this.data = data;
  }

  @JsonProperty("kind")
  @Override
  public String getKind() {
    return kind;
  }

  @JsonProperty("metadata")
  @Override
  public ResourceCollection.Metadata getMetadata() {
    return metadata;
  }

  @JsonProperty("data")
  @Override
  public ImmutableList<AclData> getData() {
    return data;
  }

  @Override
  public String toString() {
    return "AclDataList{"
        + "kind=" + kind + ", "
        + "metadata=" + metadata + ", "
        + "data=" + data
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AclDataList) {
      AclDataList that = (AclDataList) o;
      return this.kind.equals(that.getKind())
          && this.metadata.equals(that.getMetadata())
          && this.data.equals(that.getData());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= kind.hashCode();
    h$ *= 1000003;
    h$ ^= metadata.hashCode();
    h$ *= 1000003;
    h$ ^= data.hashCode();
    return h$;
  }

  static final class Builder extends AclDataList.Builder {
    private String kind;
    private ResourceCollection.Metadata metadata;
    private ImmutableList<AclData> data;
    Builder() {
    }
    @Override
    public AclDataList.Builder setKind(String kind) {
      if (kind == null) {
        throw new NullPointerException("Null kind");
      }
      this.kind = kind;
      return this;
    }
    @Override
    public AclDataList.Builder setMetadata(ResourceCollection.Metadata metadata) {
      if (metadata == null) {
        throw new NullPointerException("Null metadata");
      }
      this.metadata = metadata;
      return this;
    }
    @Override
    public AclDataList.Builder setData(List<AclData> data) {
      this.data = ImmutableList.copyOf(data);
      return this;
    }
    @Override
    public AclDataList build() {
      String missing = "";
      if (this.kind == null) {
        missing += " kind";
      }
      if (this.metadata == null) {
        missing += " metadata";
      }
      if (this.data == null) {
        missing += " data";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AclDataList(
          this.kind,
          this.metadata,
          this.data);
    }
  }

}
