package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.Acl;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_AclData extends AclData {

  private final String kind;

  private final Resource.Metadata metadata;

  private final String clusterId;

  private final Acl.ResourceType resourceType;

  private final String resourceName;

  private final Acl.PatternType patternType;

  private final String principal;

  private final String host;

  private final Acl.Operation operation;

  private final Acl.Permission permission;

  private AutoValue_AclData(
      String kind,
      Resource.Metadata metadata,
      String clusterId,
      Acl.ResourceType resourceType,
      String resourceName,
      Acl.PatternType patternType,
      String principal,
      String host,
      Acl.Operation operation,
      Acl.Permission permission) {
    this.kind = kind;
    this.metadata = metadata;
    this.clusterId = clusterId;
    this.resourceType = resourceType;
    this.resourceName = resourceName;
    this.patternType = patternType;
    this.principal = principal;
    this.host = host;
    this.operation = operation;
    this.permission = permission;
  }

  @JsonProperty("kind")
  @Override
  public String getKind() {
    return kind;
  }

  @JsonProperty("metadata")
  @Override
  public Resource.Metadata getMetadata() {
    return metadata;
  }

  @JsonProperty("cluster_id")
  @Override
  public String getClusterId() {
    return clusterId;
  }

  @JsonProperty("resource_type")
  @Override
  public Acl.ResourceType getResourceType() {
    return resourceType;
  }

  @JsonProperty("resource_name")
  @Override
  public String getResourceName() {
    return resourceName;
  }

  @JsonProperty("pattern_type")
  @Override
  public Acl.PatternType getPatternType() {
    return patternType;
  }

  @JsonProperty("principal")
  @Override
  public String getPrincipal() {
    return principal;
  }

  @JsonProperty("host")
  @Override
  public String getHost() {
    return host;
  }

  @JsonProperty("operation")
  @Override
  public Acl.Operation getOperation() {
    return operation;
  }

  @JsonProperty("permission")
  @Override
  public Acl.Permission getPermission() {
    return permission;
  }

  @Override
  public String toString() {
    return "AclData{"
        + "kind=" + kind + ", "
        + "metadata=" + metadata + ", "
        + "clusterId=" + clusterId + ", "
        + "resourceType=" + resourceType + ", "
        + "resourceName=" + resourceName + ", "
        + "patternType=" + patternType + ", "
        + "principal=" + principal + ", "
        + "host=" + host + ", "
        + "operation=" + operation + ", "
        + "permission=" + permission
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof AclData) {
      AclData that = (AclData) o;
      return this.kind.equals(that.getKind())
          && this.metadata.equals(that.getMetadata())
          && this.clusterId.equals(that.getClusterId())
          && this.resourceType.equals(that.getResourceType())
          && this.resourceName.equals(that.getResourceName())
          && this.patternType.equals(that.getPatternType())
          && this.principal.equals(that.getPrincipal())
          && this.host.equals(that.getHost())
          && this.operation.equals(that.getOperation())
          && this.permission.equals(that.getPermission());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= kind.hashCode();
    h$ *= 1000003;
    h$ ^= metadata.hashCode();
    h$ *= 1000003;
    h$ ^= clusterId.hashCode();
    h$ *= 1000003;
    h$ ^= resourceType.hashCode();
    h$ *= 1000003;
    h$ ^= resourceName.hashCode();
    h$ *= 1000003;
    h$ ^= patternType.hashCode();
    h$ *= 1000003;
    h$ ^= principal.hashCode();
    h$ *= 1000003;
    h$ ^= host.hashCode();
    h$ *= 1000003;
    h$ ^= operation.hashCode();
    h$ *= 1000003;
    h$ ^= permission.hashCode();
    return h$;
  }

  static final class Builder extends AclData.Builder {
    private String kind;
    private Resource.Metadata metadata;
    private String clusterId;
    private Acl.ResourceType resourceType;
    private String resourceName;
    private Acl.PatternType patternType;
    private String principal;
    private String host;
    private Acl.Operation operation;
    private Acl.Permission permission;
    Builder() {
    }
    @Override
    public AclData.Builder setKind(String kind) {
      if (kind == null) {
        throw new NullPointerException("Null kind");
      }
      this.kind = kind;
      return this;
    }
    @Override
    public AclData.Builder setMetadata(Resource.Metadata metadata) {
      if (metadata == null) {
        throw new NullPointerException("Null metadata");
      }
      this.metadata = metadata;
      return this;
    }
    @Override
    public AclData.Builder setClusterId(String clusterId) {
      if (clusterId == null) {
        throw new NullPointerException("Null clusterId");
      }
      this.clusterId = clusterId;
      return this;
    }
    @Override
    public AclData.Builder setResourceType(Acl.ResourceType resourceType) {
      if (resourceType == null) {
        throw new NullPointerException("Null resourceType");
      }
      this.resourceType = resourceType;
      return this;
    }
    @Override
    public AclData.Builder setResourceName(String resourceName) {
      if (resourceName == null) {
        throw new NullPointerException("Null resourceName");
      }
      this.resourceName = resourceName;
      return this;
    }
    @Override
    public AclData.Builder setPatternType(Acl.PatternType patternType) {
      if (patternType == null) {
        throw new NullPointerException("Null patternType");
      }
      this.patternType = patternType;
      return this;
    }
    @Override
    public AclData.Builder setPrincipal(String principal) {
      if (principal == null) {
        throw new NullPointerException("Null principal");
      }
      this.principal = principal;
      return this;
    }
    @Override
    public AclData.Builder setHost(String host) {
      if (host == null) {
        throw new NullPointerException("Null host");
      }
      this.host = host;
      return this;
    }
    @Override
    public AclData.Builder setOperation(Acl.Operation operation) {
      if (operation == null) {
        throw new NullPointerException("Null operation");
      }
      this.operation = operation;
      return this;
    }
    @Override
    public AclData.Builder setPermission(Acl.Permission permission) {
      if (permission == null) {
        throw new NullPointerException("Null permission");
      }
      this.permission = permission;
      return this;
    }
    @Override
    public AclData build() {
      String missing = "";
      if (this.kind == null) {
        missing += " kind";
      }
      if (this.metadata == null) {
        missing += " metadata";
      }
      if (this.clusterId == null) {
        missing += " clusterId";
      }
      if (this.resourceType == null) {
        missing += " resourceType";
      }
      if (this.resourceName == null) {
        missing += " resourceName";
      }
      if (this.patternType == null) {
        missing += " patternType";
      }
      if (this.principal == null) {
        missing += " principal";
      }
      if (this.host == null) {
        missing += " host";
      }
      if (this.operation == null) {
        missing += " operation";
      }
      if (this.permission == null) {
        missing += " permission";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_AclData(
          this.kind,
          this.metadata,
          this.clusterId,
          this.resourceType,
          this.resourceName,
          this.patternType,
          this.principal,
          this.host,
          this.operation,
          this.permission);
    }
  }

}
