package io.confluent.kafkarest.entities.v2;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import javax.annotation.Generated;
import javax.validation.constraints.NotEmpty;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ProduceRequest extends ProduceRequest {

  private final @NotEmpty ImmutableList<ProduceRequest.ProduceRecord> records;

  private final Optional<Integer> keySchemaId;

  private final Optional<String> keySchema;

  private final Optional<Integer> valueSchemaId;

  private final Optional<String> valueSchema;

  AutoValue_ProduceRequest(
      @NotEmpty ImmutableList<ProduceRequest.ProduceRecord> records,
      Optional<Integer> keySchemaId,
      Optional<String> keySchema,
      Optional<Integer> valueSchemaId,
      Optional<String> valueSchema) {
    if (records == null) {
      throw new NullPointerException("Null records");
    }
    this.records = records;
    if (keySchemaId == null) {
      throw new NullPointerException("Null keySchemaId");
    }
    this.keySchemaId = keySchemaId;
    if (keySchema == null) {
      throw new NullPointerException("Null keySchema");
    }
    this.keySchema = keySchema;
    if (valueSchemaId == null) {
      throw new NullPointerException("Null valueSchemaId");
    }
    this.valueSchemaId = valueSchemaId;
    if (valueSchema == null) {
      throw new NullPointerException("Null valueSchema");
    }
    this.valueSchema = valueSchema;
  }

  @JsonProperty("records")
  @Override
  public @NotEmpty ImmutableList<ProduceRequest.ProduceRecord> getRecords() {
    return records;
  }

  @JsonProperty("key_schema_id")
  @Override
  public Optional<Integer> getKeySchemaId() {
    return keySchemaId;
  }

  @JsonProperty("key_schema")
  @Override
  public Optional<String> getKeySchema() {
    return keySchema;
  }

  @JsonProperty("value_schema_id")
  @Override
  public Optional<Integer> getValueSchemaId() {
    return valueSchemaId;
  }

  @JsonProperty("value_schema")
  @Override
  public Optional<String> getValueSchema() {
    return valueSchema;
  }

  @Override
  public String toString() {
    return "ProduceRequest{"
        + "records=" + records + ", "
        + "keySchemaId=" + keySchemaId + ", "
        + "keySchema=" + keySchema + ", "
        + "valueSchemaId=" + valueSchemaId + ", "
        + "valueSchema=" + valueSchema
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ProduceRequest) {
      ProduceRequest that = (ProduceRequest) o;
      return this.records.equals(that.getRecords())
          && this.keySchemaId.equals(that.getKeySchemaId())
          && this.keySchema.equals(that.getKeySchema())
          && this.valueSchemaId.equals(that.getValueSchemaId())
          && this.valueSchema.equals(that.getValueSchema());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= records.hashCode();
    h$ *= 1000003;
    h$ ^= keySchemaId.hashCode();
    h$ *= 1000003;
    h$ ^= keySchema.hashCode();
    h$ *= 1000003;
    h$ ^= valueSchemaId.hashCode();
    h$ *= 1000003;
    h$ ^= valueSchema.hashCode();
    return h$;
  }

}
