package io.confluent.kafkarest.entities.v2;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ConsumerSeekRequest_PartitionOffset extends ConsumerSeekRequest.PartitionOffset {

  private final String topic;

  private final int partition;

  private final long offset;

  private final Optional<String> metadata;

  private AutoValue_ConsumerSeekRequest_PartitionOffset(
      String topic,
      int partition,
      long offset,
      Optional<String> metadata) {
    this.topic = topic;
    this.partition = partition;
    this.offset = offset;
    this.metadata = metadata;
  }

  @JsonProperty("topic")
  @Override
  public String getTopic() {
    return topic;
  }

  @JsonProperty("partition")
  @Override
  public int getPartition() {
    return partition;
  }

  @JsonProperty("offset")
  @Override
  public long getOffset() {
    return offset;
  }

  @JsonProperty("metadata")
  @Override
  public Optional<String> getMetadata() {
    return metadata;
  }

  @Override
  public String toString() {
    return "PartitionOffset{"
        + "topic=" + topic + ", "
        + "partition=" + partition + ", "
        + "offset=" + offset + ", "
        + "metadata=" + metadata
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ConsumerSeekRequest.PartitionOffset) {
      ConsumerSeekRequest.PartitionOffset that = (ConsumerSeekRequest.PartitionOffset) o;
      return this.topic.equals(that.getTopic())
          && this.partition == that.getPartition()
          && this.offset == that.getOffset()
          && this.metadata.equals(that.getMetadata());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= topic.hashCode();
    h$ *= 1000003;
    h$ ^= partition;
    h$ *= 1000003;
    h$ ^= (int) ((offset >>> 32) ^ offset);
    h$ *= 1000003;
    h$ ^= metadata.hashCode();
    return h$;
  }

  static final class Builder extends ConsumerSeekRequest.PartitionOffset.Builder {
    private String topic;
    private Integer partition;
    private Long offset;
    private Optional<String> metadata = Optional.empty();
    Builder() {
    }
    @Override
    public ConsumerSeekRequest.PartitionOffset.Builder setTopic(String topic) {
      if (topic == null) {
        throw new NullPointerException("Null topic");
      }
      this.topic = topic;
      return this;
    }
    @Override
    public ConsumerSeekRequest.PartitionOffset.Builder setPartition(int partition) {
      this.partition = partition;
      return this;
    }
    @Override
    public ConsumerSeekRequest.PartitionOffset.Builder setOffset(long offset) {
      this.offset = offset;
      return this;
    }
    @Override
    public ConsumerSeekRequest.PartitionOffset.Builder setMetadata(@Nullable String metadata) {
      this.metadata = Optional.ofNullable(metadata);
      return this;
    }
    @Override
    public ConsumerSeekRequest.PartitionOffset build() {
      String missing = "";
      if (this.topic == null) {
        missing += " topic";
      }
      if (this.partition == null) {
        missing += " partition";
      }
      if (this.offset == null) {
        missing += " offset";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ConsumerSeekRequest_PartitionOffset(
          this.topic,
          this.partition,
          this.offset,
          this.metadata);
    }
  }

}
