package io.confluent.kafkarest.entities;

import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_TopicPartitionOffset extends TopicPartitionOffset {

  private final String topic;

  private final int partition;

  private final long consumed;

  private final long committed;

  AutoValue_TopicPartitionOffset(
      String topic,
      int partition,
      long consumed,
      long committed) {
    if (topic == null) {
      throw new NullPointerException("Null topic");
    }
    this.topic = topic;
    this.partition = partition;
    this.consumed = consumed;
    this.committed = committed;
  }

  @Override
  public String getTopic() {
    return topic;
  }

  @Override
  public int getPartition() {
    return partition;
  }

  @Override
  public long getConsumed() {
    return consumed;
  }

  @Override
  public long getCommitted() {
    return committed;
  }

  @Override
  public String toString() {
    return "TopicPartitionOffset{"
        + "topic=" + topic + ", "
        + "partition=" + partition + ", "
        + "consumed=" + consumed + ", "
        + "committed=" + committed
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof TopicPartitionOffset) {
      TopicPartitionOffset that = (TopicPartitionOffset) o;
      return this.topic.equals(that.getTopic())
          && this.partition == that.getPartition()
          && this.consumed == that.getConsumed()
          && this.committed == that.getCommitted();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= topic.hashCode();
    h$ *= 1000003;
    h$ ^= partition;
    h$ *= 1000003;
    h$ ^= (int) ((consumed >>> 32) ^ consumed);
    h$ *= 1000003;
    h$ ^= (int) ((committed >>> 32) ^ committed);
    return h$;
  }

}
