package io.confluent.kafkarest.entities;

import com.google.common.collect.ImmutableList;
import java.util.Set;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Topic extends Topic {

  private final String clusterId;

  private final String name;

  private final ImmutableList<Partition> partitions;

  private final short replicationFactor;

  private final boolean internal;

  private final Set<Acl.Operation> authorizedOperations;

  AutoValue_Topic(
      String clusterId,
      String name,
      ImmutableList<Partition> partitions,
      short replicationFactor,
      boolean internal,
      Set<Acl.Operation> authorizedOperations) {
    if (clusterId == null) {
      throw new NullPointerException("Null clusterId");
    }
    this.clusterId = clusterId;
    if (name == null) {
      throw new NullPointerException("Null name");
    }
    this.name = name;
    if (partitions == null) {
      throw new NullPointerException("Null partitions");
    }
    this.partitions = partitions;
    this.replicationFactor = replicationFactor;
    this.internal = internal;
    if (authorizedOperations == null) {
      throw new NullPointerException("Null authorizedOperations");
    }
    this.authorizedOperations = authorizedOperations;
  }

  @Override
  public String getClusterId() {
    return clusterId;
  }

  @Override
  public String getName() {
    return name;
  }

  @Override
  public ImmutableList<Partition> getPartitions() {
    return partitions;
  }

  @Override
  public short getReplicationFactor() {
    return replicationFactor;
  }

  @Override
  public boolean isInternal() {
    return internal;
  }

  @Override
  public Set<Acl.Operation> getAuthorizedOperations() {
    return authorizedOperations;
  }

  @Override
  public String toString() {
    return "Topic{"
        + "clusterId=" + clusterId + ", "
        + "name=" + name + ", "
        + "partitions=" + partitions + ", "
        + "replicationFactor=" + replicationFactor + ", "
        + "internal=" + internal + ", "
        + "authorizedOperations=" + authorizedOperations
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Topic) {
      Topic that = (Topic) o;
      return this.clusterId.equals(that.getClusterId())
          && this.name.equals(that.getName())
          && this.partitions.equals(that.getPartitions())
          && this.replicationFactor == that.getReplicationFactor()
          && this.internal == that.isInternal()
          && this.authorizedOperations.equals(that.getAuthorizedOperations());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= clusterId.hashCode();
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= partitions.hashCode();
    h$ *= 1000003;
    h$ ^= replicationFactor;
    h$ *= 1000003;
    h$ ^= internal ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= authorizedOperations.hashCode();
    return h$;
  }

}
