package io.confluent.kafkarest.entities;

import io.confluent.kafka.schemaregistry.ParsedSchema;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_RegisteredSchema extends RegisteredSchema {

  private final String subject;

  private final int schemaId;

  private final int schemaVersion;

  private final ParsedSchema schema;

  AutoValue_RegisteredSchema(
      String subject,
      int schemaId,
      int schemaVersion,
      ParsedSchema schema) {
    if (subject == null) {
      throw new NullPointerException("Null subject");
    }
    this.subject = subject;
    this.schemaId = schemaId;
    this.schemaVersion = schemaVersion;
    if (schema == null) {
      throw new NullPointerException("Null schema");
    }
    this.schema = schema;
  }

  @Override
  public String getSubject() {
    return subject;
  }

  @Override
  public int getSchemaId() {
    return schemaId;
  }

  @Override
  public int getSchemaVersion() {
    return schemaVersion;
  }

  @Override
  public ParsedSchema getSchema() {
    return schema;
  }

  @Override
  public String toString() {
    return "RegisteredSchema{"
        + "subject=" + subject + ", "
        + "schemaId=" + schemaId + ", "
        + "schemaVersion=" + schemaVersion + ", "
        + "schema=" + schema
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof RegisteredSchema) {
      RegisteredSchema that = (RegisteredSchema) o;
      return this.subject.equals(that.getSubject())
          && this.schemaId == that.getSchemaId()
          && this.schemaVersion == that.getSchemaVersion()
          && this.schema.equals(that.getSchema());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= subject.hashCode();
    h$ *= 1000003;
    h$ ^= schemaId;
    h$ *= 1000003;
    h$ ^= schemaVersion;
    h$ *= 1000003;
    h$ ^= schema.hashCode();
    return h$;
  }

}
