package io.confluent.kafkarest.entities;

import com.google.common.collect.ImmutableList;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Reassignment extends Reassignment {

  private final String clusterId;

  private final String topicName;

  private final int partitionId;

  private final ImmutableList<Integer> addingReplicas;

  private final ImmutableList<Integer> removingReplicas;

  AutoValue_Reassignment(
      String clusterId,
      String topicName,
      int partitionId,
      ImmutableList<Integer> addingReplicas,
      ImmutableList<Integer> removingReplicas) {
    if (clusterId == null) {
      throw new NullPointerException("Null clusterId");
    }
    this.clusterId = clusterId;
    if (topicName == null) {
      throw new NullPointerException("Null topicName");
    }
    this.topicName = topicName;
    this.partitionId = partitionId;
    if (addingReplicas == null) {
      throw new NullPointerException("Null addingReplicas");
    }
    this.addingReplicas = addingReplicas;
    if (removingReplicas == null) {
      throw new NullPointerException("Null removingReplicas");
    }
    this.removingReplicas = removingReplicas;
  }

  @Override
  public String getClusterId() {
    return clusterId;
  }

  @Override
  public String getTopicName() {
    return topicName;
  }

  @Override
  public int getPartitionId() {
    return partitionId;
  }

  @Override
  public ImmutableList<Integer> getAddingReplicas() {
    return addingReplicas;
  }

  @Override
  public ImmutableList<Integer> getRemovingReplicas() {
    return removingReplicas;
  }

  @Override
  public String toString() {
    return "Reassignment{"
        + "clusterId=" + clusterId + ", "
        + "topicName=" + topicName + ", "
        + "partitionId=" + partitionId + ", "
        + "addingReplicas=" + addingReplicas + ", "
        + "removingReplicas=" + removingReplicas
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Reassignment) {
      Reassignment that = (Reassignment) o;
      return this.clusterId.equals(that.getClusterId())
          && this.topicName.equals(that.getTopicName())
          && this.partitionId == that.getPartitionId()
          && this.addingReplicas.equals(that.getAddingReplicas())
          && this.removingReplicas.equals(that.getRemovingReplicas());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= clusterId.hashCode();
    h$ *= 1000003;
    h$ ^= topicName.hashCode();
    h$ *= 1000003;
    h$ ^= partitionId;
    h$ *= 1000003;
    h$ ^= addingReplicas.hashCode();
    h$ *= 1000003;
    h$ ^= removingReplicas.hashCode();
    return h$;
  }

}
