package io.confluent.kafkarest.entities;

import java.time.Instant;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ProduceResult extends ProduceResult {

  private final int partitionId;

  private final long offset;

  private final Optional<Instant> timestamp;

  private final int serializedKeySize;

  private final int serializedValueSize;

  private final Instant completionTimestamp;

  AutoValue_ProduceResult(
      int partitionId,
      long offset,
      Optional<Instant> timestamp,
      int serializedKeySize,
      int serializedValueSize,
      Instant completionTimestamp) {
    this.partitionId = partitionId;
    this.offset = offset;
    if (timestamp == null) {
      throw new NullPointerException("Null timestamp");
    }
    this.timestamp = timestamp;
    this.serializedKeySize = serializedKeySize;
    this.serializedValueSize = serializedValueSize;
    if (completionTimestamp == null) {
      throw new NullPointerException("Null completionTimestamp");
    }
    this.completionTimestamp = completionTimestamp;
  }

  @Override
  public int getPartitionId() {
    return partitionId;
  }

  @Override
  public long getOffset() {
    return offset;
  }

  @Override
  public Optional<Instant> getTimestamp() {
    return timestamp;
  }

  @Override
  public int getSerializedKeySize() {
    return serializedKeySize;
  }

  @Override
  public int getSerializedValueSize() {
    return serializedValueSize;
  }

  @Override
  public Instant getCompletionTimestamp() {
    return completionTimestamp;
  }

  @Override
  public String toString() {
    return "ProduceResult{"
        + "partitionId=" + partitionId + ", "
        + "offset=" + offset + ", "
        + "timestamp=" + timestamp + ", "
        + "serializedKeySize=" + serializedKeySize + ", "
        + "serializedValueSize=" + serializedValueSize + ", "
        + "completionTimestamp=" + completionTimestamp
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ProduceResult) {
      ProduceResult that = (ProduceResult) o;
      return this.partitionId == that.getPartitionId()
          && this.offset == that.getOffset()
          && this.timestamp.equals(that.getTimestamp())
          && this.serializedKeySize == that.getSerializedKeySize()
          && this.serializedValueSize == that.getSerializedValueSize()
          && this.completionTimestamp.equals(that.getCompletionTimestamp());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= partitionId;
    h$ *= 1000003;
    h$ ^= (int) ((offset >>> 32) ^ offset);
    h$ *= 1000003;
    h$ ^= timestamp.hashCode();
    h$ *= 1000003;
    h$ ^= serializedKeySize;
    h$ *= 1000003;
    h$ ^= serializedValueSize;
    h$ *= 1000003;
    h$ ^= completionTimestamp.hashCode();
    return h$;
  }

}
