package io.confluent.kafkarest.entities;

import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ProduceRequest<K, V> extends ProduceRequest<K, V> {

  private final List<ProduceRecord<K, V>> records;

  private final String keySchema;

  private final Integer keySchemaId;

  private final String valueSchema;

  private final Integer valueSchemaId;

  AutoValue_ProduceRequest(
      List<ProduceRecord<K, V>> records,
      @Nullable String keySchema,
      @Nullable Integer keySchemaId,
      @Nullable String valueSchema,
      @Nullable Integer valueSchemaId) {
    if (records == null) {
      throw new NullPointerException("Null records");
    }
    this.records = records;
    this.keySchema = keySchema;
    this.keySchemaId = keySchemaId;
    this.valueSchema = valueSchema;
    this.valueSchemaId = valueSchemaId;
  }

  @Override
  public List<ProduceRecord<K, V>> getRecords() {
    return records;
  }

  @Nullable
  @Override
  public String getKeySchema() {
    return keySchema;
  }

  @Nullable
  @Override
  public Integer getKeySchemaId() {
    return keySchemaId;
  }

  @Nullable
  @Override
  public String getValueSchema() {
    return valueSchema;
  }

  @Nullable
  @Override
  public Integer getValueSchemaId() {
    return valueSchemaId;
  }

  @Override
  public String toString() {
    return "ProduceRequest{"
        + "records=" + records + ", "
        + "keySchema=" + keySchema + ", "
        + "keySchemaId=" + keySchemaId + ", "
        + "valueSchema=" + valueSchema + ", "
        + "valueSchemaId=" + valueSchemaId
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ProduceRequest) {
      ProduceRequest<?, ?> that = (ProduceRequest<?, ?>) o;
      return this.records.equals(that.getRecords())
          && (this.keySchema == null ? that.getKeySchema() == null : this.keySchema.equals(that.getKeySchema()))
          && (this.keySchemaId == null ? that.getKeySchemaId() == null : this.keySchemaId.equals(that.getKeySchemaId()))
          && (this.valueSchema == null ? that.getValueSchema() == null : this.valueSchema.equals(that.getValueSchema()))
          && (this.valueSchemaId == null ? that.getValueSchemaId() == null : this.valueSchemaId.equals(that.getValueSchemaId()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= records.hashCode();
    h$ *= 1000003;
    h$ ^= (keySchema == null) ? 0 : keySchema.hashCode();
    h$ *= 1000003;
    h$ ^= (keySchemaId == null) ? 0 : keySchemaId.hashCode();
    h$ *= 1000003;
    h$ ^= (valueSchema == null) ? 0 : valueSchema.hashCode();
    h$ *= 1000003;
    h$ ^= (valueSchemaId == null) ? 0 : valueSchemaId.hashCode();
    return h$;
  }

}
