package io.confluent.kafkarest.entities;

import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_PartitionReplica extends PartitionReplica {

  private final String clusterId;

  private final String topicName;

  private final int partitionId;

  private final int brokerId;

  private final boolean leader;

  private final boolean inSync;

  AutoValue_PartitionReplica(
      String clusterId,
      String topicName,
      int partitionId,
      int brokerId,
      boolean leader,
      boolean inSync) {
    if (clusterId == null) {
      throw new NullPointerException("Null clusterId");
    }
    this.clusterId = clusterId;
    if (topicName == null) {
      throw new NullPointerException("Null topicName");
    }
    this.topicName = topicName;
    this.partitionId = partitionId;
    this.brokerId = brokerId;
    this.leader = leader;
    this.inSync = inSync;
  }

  @Override
  public String getClusterId() {
    return clusterId;
  }

  @Override
  public String getTopicName() {
    return topicName;
  }

  @Override
  public int getPartitionId() {
    return partitionId;
  }

  @Override
  public int getBrokerId() {
    return brokerId;
  }

  @Override
  public boolean isLeader() {
    return leader;
  }

  @Override
  public boolean isInSync() {
    return inSync;
  }

  @Override
  public String toString() {
    return "PartitionReplica{"
        + "clusterId=" + clusterId + ", "
        + "topicName=" + topicName + ", "
        + "partitionId=" + partitionId + ", "
        + "brokerId=" + brokerId + ", "
        + "leader=" + leader + ", "
        + "inSync=" + inSync
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof PartitionReplica) {
      PartitionReplica that = (PartitionReplica) o;
      return this.clusterId.equals(that.getClusterId())
          && this.topicName.equals(that.getTopicName())
          && this.partitionId == that.getPartitionId()
          && this.brokerId == that.getBrokerId()
          && this.leader == that.isLeader()
          && this.inSync == that.isInSync();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= clusterId.hashCode();
    h$ *= 1000003;
    h$ ^= topicName.hashCode();
    h$ *= 1000003;
    h$ ^= partitionId;
    h$ *= 1000003;
    h$ ^= brokerId;
    h$ *= 1000003;
    h$ ^= leader ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= inSync ? 1231 : 1237;
    return h$;
  }

}
