package io.confluent.kafkarest.entities;

import com.google.common.collect.ImmutableList;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Partition extends Partition {

  private final String clusterId;

  private final String topicName;

  private final int partitionId;

  private final ImmutableList<PartitionReplica> replicas;

  private final Long earliestOffset;

  private final Long latestOffset;

  AutoValue_Partition(
      String clusterId,
      String topicName,
      int partitionId,
      ImmutableList<PartitionReplica> replicas,
      @Nullable Long earliestOffset,
      @Nullable Long latestOffset) {
    if (clusterId == null) {
      throw new NullPointerException("Null clusterId");
    }
    this.clusterId = clusterId;
    if (topicName == null) {
      throw new NullPointerException("Null topicName");
    }
    this.topicName = topicName;
    this.partitionId = partitionId;
    if (replicas == null) {
      throw new NullPointerException("Null replicas");
    }
    this.replicas = replicas;
    this.earliestOffset = earliestOffset;
    this.latestOffset = latestOffset;
  }

  @Override
  public String getClusterId() {
    return clusterId;
  }

  @Override
  public String getTopicName() {
    return topicName;
  }

  @Override
  public int getPartitionId() {
    return partitionId;
  }

  @Override
  public ImmutableList<PartitionReplica> getReplicas() {
    return replicas;
  }

  @Nullable
  @Override
  public Long getEarliestOffset() {
    return earliestOffset;
  }

  @Nullable
  @Override
  public Long getLatestOffset() {
    return latestOffset;
  }

  @Override
  public String toString() {
    return "Partition{"
        + "clusterId=" + clusterId + ", "
        + "topicName=" + topicName + ", "
        + "partitionId=" + partitionId + ", "
        + "replicas=" + replicas + ", "
        + "earliestOffset=" + earliestOffset + ", "
        + "latestOffset=" + latestOffset
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Partition) {
      Partition that = (Partition) o;
      return this.clusterId.equals(that.getClusterId())
          && this.topicName.equals(that.getTopicName())
          && this.partitionId == that.getPartitionId()
          && this.replicas.equals(that.getReplicas())
          && (this.earliestOffset == null ? that.getEarliestOffset() == null : this.earliestOffset.equals(that.getEarliestOffset()))
          && (this.latestOffset == null ? that.getLatestOffset() == null : this.latestOffset.equals(that.getLatestOffset()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= clusterId.hashCode();
    h$ *= 1000003;
    h$ ^= topicName.hashCode();
    h$ *= 1000003;
    h$ ^= partitionId;
    h$ *= 1000003;
    h$ ^= replicas.hashCode();
    h$ *= 1000003;
    h$ ^= (earliestOffset == null) ? 0 : earliestOffset.hashCode();
    h$ *= 1000003;
    h$ ^= (latestOffset == null) ? 0 : latestOffset.hashCode();
    return h$;
  }

}
