package io.confluent.kafkarest.entities;

import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ConsumerRecord<K, V> extends ConsumerRecord<K, V> {

  private final String topic;

  private final K key;

  private final V value;

  private final int partition;

  private final long offset;

  AutoValue_ConsumerRecord(
      String topic,
      @Nullable K key,
      @Nullable V value,
      int partition,
      long offset) {
    if (topic == null) {
      throw new NullPointerException("Null topic");
    }
    this.topic = topic;
    this.key = key;
    this.value = value;
    this.partition = partition;
    this.offset = offset;
  }

  @Override
  public String getTopic() {
    return topic;
  }

  @Nullable
  @Override
  public K getKey() {
    return key;
  }

  @Nullable
  @Override
  public V getValue() {
    return value;
  }

  @Override
  public int getPartition() {
    return partition;
  }

  @Override
  public long getOffset() {
    return offset;
  }

  @Override
  public String toString() {
    return "ConsumerRecord{"
        + "topic=" + topic + ", "
        + "key=" + key + ", "
        + "value=" + value + ", "
        + "partition=" + partition + ", "
        + "offset=" + offset
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ConsumerRecord) {
      ConsumerRecord<?, ?> that = (ConsumerRecord<?, ?>) o;
      return this.topic.equals(that.getTopic())
          && (this.key == null ? that.getKey() == null : this.key.equals(that.getKey()))
          && (this.value == null ? that.getValue() == null : this.value.equals(that.getValue()))
          && this.partition == that.getPartition()
          && this.offset == that.getOffset();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= topic.hashCode();
    h$ *= 1000003;
    h$ ^= (key == null) ? 0 : key.hashCode();
    h$ *= 1000003;
    h$ ^= (value == null) ? 0 : value.hashCode();
    h$ *= 1000003;
    h$ ^= partition;
    h$ *= 1000003;
    h$ ^= (int) ((offset >>> 32) ^ offset);
    return h$;
  }

}
