package io.confluent.kafkarest.entities;

import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ConsumerLag extends ConsumerLag {

  private final String clusterId;

  private final String consumerGroupId;

  private final String consumerId;

  private final Optional<String> instanceId;

  private final String clientId;

  private final String topicName;

  private final int partitionId;

  private final Long currentOffset;

  private final Long logEndOffset;

  private AutoValue_ConsumerLag(
      String clusterId,
      String consumerGroupId,
      String consumerId,
      Optional<String> instanceId,
      String clientId,
      String topicName,
      int partitionId,
      Long currentOffset,
      Long logEndOffset) {
    this.clusterId = clusterId;
    this.consumerGroupId = consumerGroupId;
    this.consumerId = consumerId;
    this.instanceId = instanceId;
    this.clientId = clientId;
    this.topicName = topicName;
    this.partitionId = partitionId;
    this.currentOffset = currentOffset;
    this.logEndOffset = logEndOffset;
  }

  @Override
  public String getClusterId() {
    return clusterId;
  }

  @Override
  public String getConsumerGroupId() {
    return consumerGroupId;
  }

  @Override
  public String getConsumerId() {
    return consumerId;
  }

  @Override
  public Optional<String> getInstanceId() {
    return instanceId;
  }

  @Override
  public String getClientId() {
    return clientId;
  }

  @Override
  public String getTopicName() {
    return topicName;
  }

  @Override
  public int getPartitionId() {
    return partitionId;
  }

  @Override
  public Long getCurrentOffset() {
    return currentOffset;
  }

  @Override
  public Long getLogEndOffset() {
    return logEndOffset;
  }

  @Override
  public String toString() {
    return "ConsumerLag{"
        + "clusterId=" + clusterId + ", "
        + "consumerGroupId=" + consumerGroupId + ", "
        + "consumerId=" + consumerId + ", "
        + "instanceId=" + instanceId + ", "
        + "clientId=" + clientId + ", "
        + "topicName=" + topicName + ", "
        + "partitionId=" + partitionId + ", "
        + "currentOffset=" + currentOffset + ", "
        + "logEndOffset=" + logEndOffset
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ConsumerLag) {
      ConsumerLag that = (ConsumerLag) o;
      return this.clusterId.equals(that.getClusterId())
          && this.consumerGroupId.equals(that.getConsumerGroupId())
          && this.consumerId.equals(that.getConsumerId())
          && this.instanceId.equals(that.getInstanceId())
          && this.clientId.equals(that.getClientId())
          && this.topicName.equals(that.getTopicName())
          && this.partitionId == that.getPartitionId()
          && this.currentOffset.equals(that.getCurrentOffset())
          && this.logEndOffset.equals(that.getLogEndOffset());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= clusterId.hashCode();
    h$ *= 1000003;
    h$ ^= consumerGroupId.hashCode();
    h$ *= 1000003;
    h$ ^= consumerId.hashCode();
    h$ *= 1000003;
    h$ ^= instanceId.hashCode();
    h$ *= 1000003;
    h$ ^= clientId.hashCode();
    h$ *= 1000003;
    h$ ^= topicName.hashCode();
    h$ *= 1000003;
    h$ ^= partitionId;
    h$ *= 1000003;
    h$ ^= currentOffset.hashCode();
    h$ *= 1000003;
    h$ ^= logEndOffset.hashCode();
    return h$;
  }

  static final class Builder extends ConsumerLag.Builder {
    private String clusterId;
    private String consumerGroupId;
    private String consumerId;
    private Optional<String> instanceId = Optional.empty();
    private String clientId;
    private String topicName;
    private Integer partitionId;
    private Long currentOffset;
    private Long logEndOffset;
    Builder() {
    }
    @Override
    public ConsumerLag.Builder setClusterId(String clusterId) {
      if (clusterId == null) {
        throw new NullPointerException("Null clusterId");
      }
      this.clusterId = clusterId;
      return this;
    }
    @Override
    public ConsumerLag.Builder setConsumerGroupId(String consumerGroupId) {
      if (consumerGroupId == null) {
        throw new NullPointerException("Null consumerGroupId");
      }
      this.consumerGroupId = consumerGroupId;
      return this;
    }
    @Override
    public ConsumerLag.Builder setConsumerId(String consumerId) {
      if (consumerId == null) {
        throw new NullPointerException("Null consumerId");
      }
      this.consumerId = consumerId;
      return this;
    }
    @Override
    public ConsumerLag.Builder setInstanceId(Optional<String> instanceId) {
      if (instanceId == null) {
        throw new NullPointerException("Null instanceId");
      }
      this.instanceId = instanceId;
      return this;
    }
    @Override
    public ConsumerLag.Builder setClientId(String clientId) {
      if (clientId == null) {
        throw new NullPointerException("Null clientId");
      }
      this.clientId = clientId;
      return this;
    }
    @Override
    public ConsumerLag.Builder setTopicName(String topicName) {
      if (topicName == null) {
        throw new NullPointerException("Null topicName");
      }
      this.topicName = topicName;
      return this;
    }
    @Override
    public ConsumerLag.Builder setPartitionId(int partitionId) {
      this.partitionId = partitionId;
      return this;
    }
    @Override
    public ConsumerLag.Builder setCurrentOffset(Long currentOffset) {
      if (currentOffset == null) {
        throw new NullPointerException("Null currentOffset");
      }
      this.currentOffset = currentOffset;
      return this;
    }
    @Override
    public ConsumerLag.Builder setLogEndOffset(Long logEndOffset) {
      if (logEndOffset == null) {
        throw new NullPointerException("Null logEndOffset");
      }
      this.logEndOffset = logEndOffset;
      return this;
    }
    @Override
    public ConsumerLag build() {
      String missing = "";
      if (this.clusterId == null) {
        missing += " clusterId";
      }
      if (this.consumerGroupId == null) {
        missing += " consumerGroupId";
      }
      if (this.consumerId == null) {
        missing += " consumerId";
      }
      if (this.clientId == null) {
        missing += " clientId";
      }
      if (this.topicName == null) {
        missing += " topicName";
      }
      if (this.partitionId == null) {
        missing += " partitionId";
      }
      if (this.currentOffset == null) {
        missing += " currentOffset";
      }
      if (this.logEndOffset == null) {
        missing += " logEndOffset";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ConsumerLag(
          this.clusterId,
          this.consumerGroupId,
          this.consumerId,
          this.instanceId,
          this.clientId,
          this.topicName,
          this.partitionId,
          this.currentOffset,
          this.logEndOffset);
    }
  }

}
