package io.confluent.kafkarest.entities;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ConsumerGroup extends ConsumerGroup {

  private final String clusterId;

  private final String consumerGroupId;

  private final boolean simple;

  private final String partitionAssignor;

  private final ConsumerGroup.State state;

  private final Broker coordinator;

  private final ImmutableList<Consumer> consumers;

  private AutoValue_ConsumerGroup(
      String clusterId,
      String consumerGroupId,
      boolean simple,
      String partitionAssignor,
      ConsumerGroup.State state,
      Broker coordinator,
      ImmutableList<Consumer> consumers) {
    this.clusterId = clusterId;
    this.consumerGroupId = consumerGroupId;
    this.simple = simple;
    this.partitionAssignor = partitionAssignor;
    this.state = state;
    this.coordinator = coordinator;
    this.consumers = consumers;
  }

  @Override
  public String getClusterId() {
    return clusterId;
  }

  @Override
  public String getConsumerGroupId() {
    return consumerGroupId;
  }

  @Override
  public boolean isSimple() {
    return simple;
  }

  @Override
  public String getPartitionAssignor() {
    return partitionAssignor;
  }

  @Override
  public ConsumerGroup.State getState() {
    return state;
  }

  @Override
  public Broker getCoordinator() {
    return coordinator;
  }

  @Override
  public ImmutableList<Consumer> getConsumers() {
    return consumers;
  }

  @Override
  public String toString() {
    return "ConsumerGroup{"
        + "clusterId=" + clusterId + ", "
        + "consumerGroupId=" + consumerGroupId + ", "
        + "simple=" + simple + ", "
        + "partitionAssignor=" + partitionAssignor + ", "
        + "state=" + state + ", "
        + "coordinator=" + coordinator + ", "
        + "consumers=" + consumers
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ConsumerGroup) {
      ConsumerGroup that = (ConsumerGroup) o;
      return this.clusterId.equals(that.getClusterId())
          && this.consumerGroupId.equals(that.getConsumerGroupId())
          && this.simple == that.isSimple()
          && this.partitionAssignor.equals(that.getPartitionAssignor())
          && this.state.equals(that.getState())
          && this.coordinator.equals(that.getCoordinator())
          && this.consumers.equals(that.getConsumers());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= clusterId.hashCode();
    h$ *= 1000003;
    h$ ^= consumerGroupId.hashCode();
    h$ *= 1000003;
    h$ ^= simple ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= partitionAssignor.hashCode();
    h$ *= 1000003;
    h$ ^= state.hashCode();
    h$ *= 1000003;
    h$ ^= coordinator.hashCode();
    h$ *= 1000003;
    h$ ^= consumers.hashCode();
    return h$;
  }

  static final class Builder extends ConsumerGroup.Builder {
    private String clusterId;
    private String consumerGroupId;
    private Boolean simple;
    private String partitionAssignor;
    private ConsumerGroup.State state;
    private Broker coordinator;
    private ImmutableList<Consumer> consumers;
    Builder() {
    }
    @Override
    public ConsumerGroup.Builder setClusterId(String clusterId) {
      if (clusterId == null) {
        throw new NullPointerException("Null clusterId");
      }
      this.clusterId = clusterId;
      return this;
    }
    @Override
    public ConsumerGroup.Builder setConsumerGroupId(String consumerGroupId) {
      if (consumerGroupId == null) {
        throw new NullPointerException("Null consumerGroupId");
      }
      this.consumerGroupId = consumerGroupId;
      return this;
    }
    @Override
    public ConsumerGroup.Builder setSimple(boolean simple) {
      this.simple = simple;
      return this;
    }
    @Override
    public ConsumerGroup.Builder setPartitionAssignor(String partitionAssignor) {
      if (partitionAssignor == null) {
        throw new NullPointerException("Null partitionAssignor");
      }
      this.partitionAssignor = partitionAssignor;
      return this;
    }
    @Override
    public ConsumerGroup.Builder setState(ConsumerGroup.State state) {
      if (state == null) {
        throw new NullPointerException("Null state");
      }
      this.state = state;
      return this;
    }
    @Override
    public ConsumerGroup.Builder setCoordinator(Broker coordinator) {
      if (coordinator == null) {
        throw new NullPointerException("Null coordinator");
      }
      this.coordinator = coordinator;
      return this;
    }
    @Override
    public ConsumerGroup.Builder setConsumers(List<Consumer> consumers) {
      this.consumers = ImmutableList.copyOf(consumers);
      return this;
    }
    @Override
    public ConsumerGroup build() {
      String missing = "";
      if (this.clusterId == null) {
        missing += " clusterId";
      }
      if (this.consumerGroupId == null) {
        missing += " consumerGroupId";
      }
      if (this.simple == null) {
        missing += " simple";
      }
      if (this.partitionAssignor == null) {
        missing += " partitionAssignor";
      }
      if (this.state == null) {
        missing += " state";
      }
      if (this.coordinator == null) {
        missing += " coordinator";
      }
      if (this.consumers == null) {
        missing += " consumers";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ConsumerGroup(
          this.clusterId,
          this.consumerGroupId,
          this.simple,
          this.partitionAssignor,
          this.state,
          this.coordinator,
          this.consumers);
    }
  }

}
