package io.confluent.kafkarest.entities;

import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ConsumerAssignment extends ConsumerAssignment {

  private final String clusterId;

  private final String consumerGroupId;

  private final String consumerId;

  private final String topicName;

  private final int partitionId;

  private AutoValue_ConsumerAssignment(
      String clusterId,
      String consumerGroupId,
      String consumerId,
      String topicName,
      int partitionId) {
    this.clusterId = clusterId;
    this.consumerGroupId = consumerGroupId;
    this.consumerId = consumerId;
    this.topicName = topicName;
    this.partitionId = partitionId;
  }

  @Override
  public String getClusterId() {
    return clusterId;
  }

  @Override
  public String getConsumerGroupId() {
    return consumerGroupId;
  }

  @Override
  public String getConsumerId() {
    return consumerId;
  }

  @Override
  public String getTopicName() {
    return topicName;
  }

  @Override
  public int getPartitionId() {
    return partitionId;
  }

  @Override
  public String toString() {
    return "ConsumerAssignment{"
        + "clusterId=" + clusterId + ", "
        + "consumerGroupId=" + consumerGroupId + ", "
        + "consumerId=" + consumerId + ", "
        + "topicName=" + topicName + ", "
        + "partitionId=" + partitionId
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ConsumerAssignment) {
      ConsumerAssignment that = (ConsumerAssignment) o;
      return this.clusterId.equals(that.getClusterId())
          && this.consumerGroupId.equals(that.getConsumerGroupId())
          && this.consumerId.equals(that.getConsumerId())
          && this.topicName.equals(that.getTopicName())
          && this.partitionId == that.getPartitionId();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= clusterId.hashCode();
    h$ *= 1000003;
    h$ ^= consumerGroupId.hashCode();
    h$ *= 1000003;
    h$ ^= consumerId.hashCode();
    h$ *= 1000003;
    h$ ^= topicName.hashCode();
    h$ *= 1000003;
    h$ ^= partitionId;
    return h$;
  }

  static final class Builder extends ConsumerAssignment.Builder {
    private String clusterId;
    private String consumerGroupId;
    private String consumerId;
    private String topicName;
    private Integer partitionId;
    Builder() {
    }
    @Override
    public ConsumerAssignment.Builder setClusterId(String clusterId) {
      if (clusterId == null) {
        throw new NullPointerException("Null clusterId");
      }
      this.clusterId = clusterId;
      return this;
    }
    @Override
    public ConsumerAssignment.Builder setConsumerGroupId(String consumerGroupId) {
      if (consumerGroupId == null) {
        throw new NullPointerException("Null consumerGroupId");
      }
      this.consumerGroupId = consumerGroupId;
      return this;
    }
    @Override
    public ConsumerAssignment.Builder setConsumerId(String consumerId) {
      if (consumerId == null) {
        throw new NullPointerException("Null consumerId");
      }
      this.consumerId = consumerId;
      return this;
    }
    @Override
    public ConsumerAssignment.Builder setTopicName(String topicName) {
      if (topicName == null) {
        throw new NullPointerException("Null topicName");
      }
      this.topicName = topicName;
      return this;
    }
    @Override
    public ConsumerAssignment.Builder setPartitionId(int partitionId) {
      this.partitionId = partitionId;
      return this;
    }
    @Override
    public ConsumerAssignment build() {
      String missing = "";
      if (this.clusterId == null) {
        missing += " clusterId";
      }
      if (this.consumerGroupId == null) {
        missing += " consumerGroupId";
      }
      if (this.consumerId == null) {
        missing += " consumerId";
      }
      if (this.topicName == null) {
        missing += " topicName";
      }
      if (this.partitionId == null) {
        missing += " partitionId";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ConsumerAssignment(
          this.clusterId,
          this.consumerGroupId,
          this.consumerId,
          this.topicName,
          this.partitionId);
    }
  }

}
