package io.confluent.kafkarest.entities;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Consumer extends Consumer {

  private final String clusterId;

  private final String consumerGroupId;

  private final String consumerId;

  private final Optional<String> instanceId;

  private final String clientId;

  private final String host;

  private final ImmutableList<Partition> assignedPartitions;

  private AutoValue_Consumer(
      String clusterId,
      String consumerGroupId,
      String consumerId,
      Optional<String> instanceId,
      String clientId,
      String host,
      ImmutableList<Partition> assignedPartitions) {
    this.clusterId = clusterId;
    this.consumerGroupId = consumerGroupId;
    this.consumerId = consumerId;
    this.instanceId = instanceId;
    this.clientId = clientId;
    this.host = host;
    this.assignedPartitions = assignedPartitions;
  }

  @Override
  public String getClusterId() {
    return clusterId;
  }

  @Override
  public String getConsumerGroupId() {
    return consumerGroupId;
  }

  @Override
  public String getConsumerId() {
    return consumerId;
  }

  @Override
  public Optional<String> getInstanceId() {
    return instanceId;
  }

  @Override
  public String getClientId() {
    return clientId;
  }

  @Override
  public String getHost() {
    return host;
  }

  @Override
  public ImmutableList<Partition> getAssignedPartitions() {
    return assignedPartitions;
  }

  @Override
  public String toString() {
    return "Consumer{"
        + "clusterId=" + clusterId + ", "
        + "consumerGroupId=" + consumerGroupId + ", "
        + "consumerId=" + consumerId + ", "
        + "instanceId=" + instanceId + ", "
        + "clientId=" + clientId + ", "
        + "host=" + host + ", "
        + "assignedPartitions=" + assignedPartitions
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Consumer) {
      Consumer that = (Consumer) o;
      return this.clusterId.equals(that.getClusterId())
          && this.consumerGroupId.equals(that.getConsumerGroupId())
          && this.consumerId.equals(that.getConsumerId())
          && this.instanceId.equals(that.getInstanceId())
          && this.clientId.equals(that.getClientId())
          && this.host.equals(that.getHost())
          && this.assignedPartitions.equals(that.getAssignedPartitions());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= clusterId.hashCode();
    h$ *= 1000003;
    h$ ^= consumerGroupId.hashCode();
    h$ *= 1000003;
    h$ ^= consumerId.hashCode();
    h$ *= 1000003;
    h$ ^= instanceId.hashCode();
    h$ *= 1000003;
    h$ ^= clientId.hashCode();
    h$ *= 1000003;
    h$ ^= host.hashCode();
    h$ *= 1000003;
    h$ ^= assignedPartitions.hashCode();
    return h$;
  }

  static final class Builder extends Consumer.Builder {
    private String clusterId;
    private String consumerGroupId;
    private String consumerId;
    private Optional<String> instanceId = Optional.empty();
    private String clientId;
    private String host;
    private ImmutableList<Partition> assignedPartitions;
    Builder() {
    }
    @Override
    public Consumer.Builder setClusterId(String clusterId) {
      if (clusterId == null) {
        throw new NullPointerException("Null clusterId");
      }
      this.clusterId = clusterId;
      return this;
    }
    @Override
    public Consumer.Builder setConsumerGroupId(String consumerGroupId) {
      if (consumerGroupId == null) {
        throw new NullPointerException("Null consumerGroupId");
      }
      this.consumerGroupId = consumerGroupId;
      return this;
    }
    @Override
    public Consumer.Builder setConsumerId(String consumerId) {
      if (consumerId == null) {
        throw new NullPointerException("Null consumerId");
      }
      this.consumerId = consumerId;
      return this;
    }
    @Override
    public Consumer.Builder setInstanceId(@Nullable String instanceId) {
      this.instanceId = Optional.ofNullable(instanceId);
      return this;
    }
    @Override
    public Consumer.Builder setClientId(String clientId) {
      if (clientId == null) {
        throw new NullPointerException("Null clientId");
      }
      this.clientId = clientId;
      return this;
    }
    @Override
    public Consumer.Builder setHost(String host) {
      if (host == null) {
        throw new NullPointerException("Null host");
      }
      this.host = host;
      return this;
    }
    @Override
    public Consumer.Builder setAssignedPartitions(List<Partition> assignedPartitions) {
      this.assignedPartitions = ImmutableList.copyOf(assignedPartitions);
      return this;
    }
    @Override
    public Consumer build() {
      String missing = "";
      if (this.clusterId == null) {
        missing += " clusterId";
      }
      if (this.consumerGroupId == null) {
        missing += " consumerGroupId";
      }
      if (this.consumerId == null) {
        missing += " consumerId";
      }
      if (this.clientId == null) {
        missing += " clientId";
      }
      if (this.host == null) {
        missing += " host";
      }
      if (this.assignedPartitions == null) {
        missing += " assignedPartitions";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Consumer(
          this.clusterId,
          this.consumerGroupId,
          this.consumerId,
          this.instanceId,
          this.clientId,
          this.host,
          this.assignedPartitions);
    }
  }

}
