package io.confluent.kafkarest.entities;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ClusterConfig extends ClusterConfig {

  private final String clusterId;

  private final String name;

  private final String value;

  private final boolean default0;

  private final boolean readOnly;

  private final boolean sensitive;

  private final ConfigSource source;

  private final ImmutableList<ConfigSynonym> synonyms;

  private final ClusterConfig.Type type;

  private AutoValue_ClusterConfig(
      String clusterId,
      String name,
      @Nullable String value,
      boolean default0,
      boolean readOnly,
      boolean sensitive,
      ConfigSource source,
      ImmutableList<ConfigSynonym> synonyms,
      ClusterConfig.Type type) {
    this.clusterId = clusterId;
    this.name = name;
    this.value = value;
    this.default0 = default0;
    this.readOnly = readOnly;
    this.sensitive = sensitive;
    this.source = source;
    this.synonyms = synonyms;
    this.type = type;
  }

  @Override
  public String getClusterId() {
    return clusterId;
  }

  @Override
  public String getName() {
    return name;
  }

  @Nullable
  @Override
  public String getValue() {
    return value;
  }

  @Override
  public boolean isDefault() {
    return default0;
  }

  @Override
  public boolean isReadOnly() {
    return readOnly;
  }

  @Override
  public boolean isSensitive() {
    return sensitive;
  }

  @Override
  public ConfigSource getSource() {
    return source;
  }

  @Override
  public ImmutableList<ConfigSynonym> getSynonyms() {
    return synonyms;
  }

  @Override
  public ClusterConfig.Type getType() {
    return type;
  }

  @Override
  public String toString() {
    return "ClusterConfig{"
        + "clusterId=" + clusterId + ", "
        + "name=" + name + ", "
        + "value=" + value + ", "
        + "default=" + default0 + ", "
        + "readOnly=" + readOnly + ", "
        + "sensitive=" + sensitive + ", "
        + "source=" + source + ", "
        + "synonyms=" + synonyms + ", "
        + "type=" + type
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ClusterConfig) {
      ClusterConfig that = (ClusterConfig) o;
      return this.clusterId.equals(that.getClusterId())
          && this.name.equals(that.getName())
          && (this.value == null ? that.getValue() == null : this.value.equals(that.getValue()))
          && this.default0 == that.isDefault()
          && this.readOnly == that.isReadOnly()
          && this.sensitive == that.isSensitive()
          && this.source.equals(that.getSource())
          && this.synonyms.equals(that.getSynonyms())
          && this.type.equals(that.getType());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= clusterId.hashCode();
    h$ *= 1000003;
    h$ ^= name.hashCode();
    h$ *= 1000003;
    h$ ^= (value == null) ? 0 : value.hashCode();
    h$ *= 1000003;
    h$ ^= default0 ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= readOnly ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= sensitive ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= source.hashCode();
    h$ *= 1000003;
    h$ ^= synonyms.hashCode();
    h$ *= 1000003;
    h$ ^= type.hashCode();
    return h$;
  }

  static final class Builder extends ClusterConfig.Builder {
    private String clusterId;
    private String name;
    private String value;
    private Boolean default0;
    private Boolean readOnly;
    private Boolean sensitive;
    private ConfigSource source;
    private ImmutableList<ConfigSynonym> synonyms;
    private ClusterConfig.Type type;
    Builder() {
    }
    @Override
    public ClusterConfig.Builder setClusterId(String clusterId) {
      if (clusterId == null) {
        throw new NullPointerException("Null clusterId");
      }
      this.clusterId = clusterId;
      return this;
    }
    @Override
    public ClusterConfig.Builder setName(String name) {
      if (name == null) {
        throw new NullPointerException("Null name");
      }
      this.name = name;
      return this;
    }
    @Override
    public ClusterConfig.Builder setValue(@Nullable String value) {
      this.value = value;
      return this;
    }
    @Override
    public ClusterConfig.Builder setDefault(boolean default0) {
      this.default0 = default0;
      return this;
    }
    @Override
    public ClusterConfig.Builder setReadOnly(boolean readOnly) {
      this.readOnly = readOnly;
      return this;
    }
    @Override
    public ClusterConfig.Builder setSensitive(boolean sensitive) {
      this.sensitive = sensitive;
      return this;
    }
    @Override
    public ClusterConfig.Builder setSource(ConfigSource source) {
      if (source == null) {
        throw new NullPointerException("Null source");
      }
      this.source = source;
      return this;
    }
    @Override
    public ClusterConfig.Builder setSynonyms(List<ConfigSynonym> synonyms) {
      this.synonyms = ImmutableList.copyOf(synonyms);
      return this;
    }
    @Override
    public ClusterConfig.Builder setType(ClusterConfig.Type type) {
      if (type == null) {
        throw new NullPointerException("Null type");
      }
      this.type = type;
      return this;
    }
    @Override
    public ClusterConfig build() {
      String missing = "";
      if (this.clusterId == null) {
        missing += " clusterId";
      }
      if (this.name == null) {
        missing += " name";
      }
      if (this.default0 == null) {
        missing += " default";
      }
      if (this.readOnly == null) {
        missing += " readOnly";
      }
      if (this.sensitive == null) {
        missing += " sensitive";
      }
      if (this.source == null) {
        missing += " source";
      }
      if (this.synonyms == null) {
        missing += " synonyms";
      }
      if (this.type == null) {
        missing += " type";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ClusterConfig(
          this.clusterId,
          this.name,
          this.value,
          this.default0,
          this.readOnly,
          this.sensitive,
          this.source,
          this.synonyms,
          this.type);
    }
  }

}
