package io.confluent.kafkarest.entities;

import com.google.common.collect.ImmutableList;
import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Cluster extends Cluster {

  private final String clusterId;

  private final Broker controller;

  private final ImmutableList<Broker> brokers;

  private AutoValue_Cluster(
      String clusterId,
      @Nullable Broker controller,
      ImmutableList<Broker> brokers) {
    this.clusterId = clusterId;
    this.controller = controller;
    this.brokers = brokers;
  }

  @Override
  public String getClusterId() {
    return clusterId;
  }

  @Nullable
  @Override
  public Broker getController() {
    return controller;
  }

  @Override
  public ImmutableList<Broker> getBrokers() {
    return brokers;
  }

  @Override
  public String toString() {
    return "Cluster{"
        + "clusterId=" + clusterId + ", "
        + "controller=" + controller + ", "
        + "brokers=" + brokers
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Cluster) {
      Cluster that = (Cluster) o;
      return this.clusterId.equals(that.getClusterId())
          && (this.controller == null ? that.getController() == null : this.controller.equals(that.getController()))
          && this.brokers.equals(that.getBrokers());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= clusterId.hashCode();
    h$ *= 1000003;
    h$ ^= (controller == null) ? 0 : controller.hashCode();
    h$ *= 1000003;
    h$ ^= brokers.hashCode();
    return h$;
  }

  static final class Builder extends Cluster.Builder {
    private String clusterId;
    private Broker controller;
    private ImmutableList.Builder<Broker> brokersBuilder$;
    private ImmutableList<Broker> brokers;
    Builder() {
    }
    @Override
    public Cluster.Builder setClusterId(String clusterId) {
      if (clusterId == null) {
        throw new NullPointerException("Null clusterId");
      }
      this.clusterId = clusterId;
      return this;
    }
    @Override
    public Cluster.Builder setController(Broker controller) {
      this.controller = controller;
      return this;
    }
    @Override
    ImmutableList.Builder<Broker> brokersBuilder() {
      if (brokersBuilder$ == null) {
        brokersBuilder$ = ImmutableList.builder();
      }
      return brokersBuilder$;
    }
    @Override
    public Cluster build() {
      if (brokersBuilder$ != null) {
        this.brokers = brokersBuilder$.build();
      } else if (this.brokers == null) {
        this.brokers = ImmutableList.of();
      }
      String missing = "";
      if (this.clusterId == null) {
        missing += " clusterId";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Cluster(
          this.clusterId,
          this.controller,
          this.brokers);
    }
  }

}
