package io.confluent.kafkarest.entities;

import javax.annotation.Generated;
import javax.annotation.Nullable;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Broker extends Broker {

  private final String clusterId;

  private final int brokerId;

  private final String host;

  private final Integer port;

  private final String rack;

  AutoValue_Broker(
      String clusterId,
      int brokerId,
      @Nullable String host,
      @Nullable Integer port,
      @Nullable String rack) {
    if (clusterId == null) {
      throw new NullPointerException("Null clusterId");
    }
    this.clusterId = clusterId;
    this.brokerId = brokerId;
    this.host = host;
    this.port = port;
    this.rack = rack;
  }

  @Override
  public String getClusterId() {
    return clusterId;
  }

  @Override
  public int getBrokerId() {
    return brokerId;
  }

  @Nullable
  @Override
  public String getHost() {
    return host;
  }

  @Nullable
  @Override
  public Integer getPort() {
    return port;
  }

  @Nullable
  @Override
  public String getRack() {
    return rack;
  }

  @Override
  public String toString() {
    return "Broker{"
        + "clusterId=" + clusterId + ", "
        + "brokerId=" + brokerId + ", "
        + "host=" + host + ", "
        + "port=" + port + ", "
        + "rack=" + rack
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Broker) {
      Broker that = (Broker) o;
      return this.clusterId.equals(that.getClusterId())
          && this.brokerId == that.getBrokerId()
          && (this.host == null ? that.getHost() == null : this.host.equals(that.getHost()))
          && (this.port == null ? that.getPort() == null : this.port.equals(that.getPort()))
          && (this.rack == null ? that.getRack() == null : this.rack.equals(that.getRack()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= clusterId.hashCode();
    h$ *= 1000003;
    h$ ^= brokerId;
    h$ *= 1000003;
    h$ ^= (host == null) ? 0 : host.hashCode();
    h$ *= 1000003;
    h$ ^= (port == null) ? 0 : port.hashCode();
    h$ *= 1000003;
    h$ ^= (rack == null) ? 0 : rack.hashCode();
    return h$;
  }

}
