package io.confluent.kafkarest.entities;

import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_Acl extends Acl {

  private final String clusterId;

  private final Acl.ResourceType resourceType;

  private final String resourceName;

  private final Acl.PatternType patternType;

  private final String principal;

  private final String host;

  private final Acl.Operation operation;

  private final Acl.Permission permission;

  private AutoValue_Acl(
      String clusterId,
      Acl.ResourceType resourceType,
      String resourceName,
      Acl.PatternType patternType,
      String principal,
      String host,
      Acl.Operation operation,
      Acl.Permission permission) {
    this.clusterId = clusterId;
    this.resourceType = resourceType;
    this.resourceName = resourceName;
    this.patternType = patternType;
    this.principal = principal;
    this.host = host;
    this.operation = operation;
    this.permission = permission;
  }

  @Override
  public String getClusterId() {
    return clusterId;
  }

  @Override
  public Acl.ResourceType getResourceType() {
    return resourceType;
  }

  @Override
  public String getResourceName() {
    return resourceName;
  }

  @Override
  public Acl.PatternType getPatternType() {
    return patternType;
  }

  @Override
  public String getPrincipal() {
    return principal;
  }

  @Override
  public String getHost() {
    return host;
  }

  @Override
  public Acl.Operation getOperation() {
    return operation;
  }

  @Override
  public Acl.Permission getPermission() {
    return permission;
  }

  @Override
  public String toString() {
    return "Acl{"
        + "clusterId=" + clusterId + ", "
        + "resourceType=" + resourceType + ", "
        + "resourceName=" + resourceName + ", "
        + "patternType=" + patternType + ", "
        + "principal=" + principal + ", "
        + "host=" + host + ", "
        + "operation=" + operation + ", "
        + "permission=" + permission
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof Acl) {
      Acl that = (Acl) o;
      return this.clusterId.equals(that.getClusterId())
          && this.resourceType.equals(that.getResourceType())
          && this.resourceName.equals(that.getResourceName())
          && this.patternType.equals(that.getPatternType())
          && this.principal.equals(that.getPrincipal())
          && this.host.equals(that.getHost())
          && this.operation.equals(that.getOperation())
          && this.permission.equals(that.getPermission());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= clusterId.hashCode();
    h$ *= 1000003;
    h$ ^= resourceType.hashCode();
    h$ *= 1000003;
    h$ ^= resourceName.hashCode();
    h$ *= 1000003;
    h$ ^= patternType.hashCode();
    h$ *= 1000003;
    h$ ^= principal.hashCode();
    h$ *= 1000003;
    h$ ^= host.hashCode();
    h$ *= 1000003;
    h$ ^= operation.hashCode();
    h$ *= 1000003;
    h$ ^= permission.hashCode();
    return h$;
  }

  static final class Builder extends Acl.Builder {
    private String clusterId;
    private Acl.ResourceType resourceType;
    private String resourceName;
    private Acl.PatternType patternType;
    private String principal;
    private String host;
    private Acl.Operation operation;
    private Acl.Permission permission;
    Builder() {
    }
    @Override
    public Acl.Builder setClusterId(String clusterId) {
      if (clusterId == null) {
        throw new NullPointerException("Null clusterId");
      }
      this.clusterId = clusterId;
      return this;
    }
    @Override
    public Acl.Builder setResourceType(Acl.ResourceType resourceType) {
      if (resourceType == null) {
        throw new NullPointerException("Null resourceType");
      }
      this.resourceType = resourceType;
      return this;
    }
    @Override
    public Acl.Builder setResourceName(String resourceName) {
      if (resourceName == null) {
        throw new NullPointerException("Null resourceName");
      }
      this.resourceName = resourceName;
      return this;
    }
    @Override
    public Acl.Builder setPatternType(Acl.PatternType patternType) {
      if (patternType == null) {
        throw new NullPointerException("Null patternType");
      }
      this.patternType = patternType;
      return this;
    }
    @Override
    public Acl.Builder setPrincipal(String principal) {
      if (principal == null) {
        throw new NullPointerException("Null principal");
      }
      this.principal = principal;
      return this;
    }
    @Override
    public Acl.Builder setHost(String host) {
      if (host == null) {
        throw new NullPointerException("Null host");
      }
      this.host = host;
      return this;
    }
    @Override
    public Acl.Builder setOperation(Acl.Operation operation) {
      if (operation == null) {
        throw new NullPointerException("Null operation");
      }
      this.operation = operation;
      return this;
    }
    @Override
    public Acl.Builder setPermission(Acl.Permission permission) {
      if (permission == null) {
        throw new NullPointerException("Null permission");
      }
      this.permission = permission;
      return this;
    }
    @Override
    public Acl build() {
      String missing = "";
      if (this.clusterId == null) {
        missing += " clusterId";
      }
      if (this.resourceType == null) {
        missing += " resourceType";
      }
      if (this.resourceName == null) {
        missing += " resourceName";
      }
      if (this.patternType == null) {
        missing += " patternType";
      }
      if (this.principal == null) {
        missing += " principal";
      }
      if (this.host == null) {
        missing += " host";
      }
      if (this.operation == null) {
        missing += " operation";
      }
      if (this.permission == null) {
        missing += " permission";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_Acl(
          this.clusterId,
          this.resourceType,
          this.resourceName,
          this.patternType,
          this.principal,
          this.host,
          this.operation,
          this.permission);
    }
  }

}
