/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.Response;

public final class AsyncResponses {
    private AsyncResponses() {
    }

    public static <T> void asyncResume(AsyncResponse asyncResponse, CompletableFuture<T> entity) {
        AsyncResponseBuilder.from(Response.ok()).entity(entity).asyncResume(asyncResponse);
    }

    public static final class AsyncResponseBuilder<T> {
        private final Response.ResponseBuilder responseBuilder;
        @Nullable
        private CompletableFuture<? extends T> entityFuture;
        @Nullable
        private Annotation[] entityAnnotations;
        @Nullable
        private Function<? super T, Response.Status> statusFunction;

        private AsyncResponseBuilder(Response.ResponseBuilder responseBuilder) {
            this.responseBuilder = responseBuilder.clone();
        }

        public static <T> AsyncResponseBuilder<T> from(Response.ResponseBuilder responseBuilder) {
            return new AsyncResponseBuilder<T>(responseBuilder);
        }

        public AsyncResponseBuilder<T> entity(CompletableFuture<? extends T> entity) {
            this.entityFuture = entity;
            return this;
        }

        public AsyncResponseBuilder<T> entity(CompletableFuture<? extends T> entity, Annotation[] annotations) {
            this.entityFuture = entity;
            this.entityAnnotations = Arrays.copyOf(annotations, annotations.length);
            return this;
        }

        public AsyncResponseBuilder<T> status(Function<? super T, Response.Status> statusFunction) {
            this.statusFunction = statusFunction;
            return this;
        }

        public void asyncResume(AsyncResponse asyncResponse) {
            if (this.entityFuture == null) {
                throw new IllegalStateException();
            }
            this.entityFuture.whenComplete((entity, exception) -> {
                if (exception == null) {
                    if (this.statusFunction != null) {
                        this.responseBuilder.status(this.statusFunction.apply(entity));
                    }
                    if (this.entityAnnotations != null) {
                        asyncResponse.resume((Object)this.responseBuilder.entity(entity, this.entityAnnotations).build());
                    } else {
                        asyncResponse.resume((Object)this.responseBuilder.entity(entity).build());
                    }
                } else if (exception instanceof CompletionException) {
                    asyncResponse.resume(exception.getCause());
                } else {
                    asyncResponse.resume(exception);
                }
            });
        }
    }
}

