/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities.v3;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.confluent.kafkarest.entities.v3.ProduceResponse;
import java.time.Instant;
import java.util.Optional;
import javax.annotation.Nullable;

final class AutoValue_ProduceResponse
extends ProduceResponse {
    private final int errorCode;
    private final String clusterId;
    private final String topicName;
    private final int partitionId;
    private final long offset;
    private final Optional<Instant> timestamp;
    private final Optional<ProduceResponse.ProduceResponseData> key;
    private final Optional<ProduceResponse.ProduceResponseData> value;

    private AutoValue_ProduceResponse(int errorCode, String clusterId, String topicName, int partitionId, long offset, Optional<Instant> timestamp, Optional<ProduceResponse.ProduceResponseData> key, Optional<ProduceResponse.ProduceResponseData> value) {
        this.errorCode = errorCode;
        this.clusterId = clusterId;
        this.topicName = topicName;
        this.partitionId = partitionId;
        this.offset = offset;
        this.timestamp = timestamp;
        this.key = key;
        this.value = value;
    }

    @Override
    @JsonProperty(value="error_code")
    public int getErrorCode() {
        return this.errorCode;
    }

    @Override
    @JsonProperty(value="cluster_id")
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    @JsonProperty(value="topic_name")
    public String getTopicName() {
        return this.topicName;
    }

    @Override
    @JsonProperty(value="partition_id")
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    @JsonProperty(value="offset")
    public long getOffset() {
        return this.offset;
    }

    @Override
    @JsonProperty(value="timestamp")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public Optional<Instant> getTimestamp() {
        return this.timestamp;
    }

    @Override
    @JsonProperty(value="key")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public Optional<ProduceResponse.ProduceResponseData> getKey() {
        return this.key;
    }

    @Override
    @JsonProperty(value="value")
    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    public Optional<ProduceResponse.ProduceResponseData> getValue() {
        return this.value;
    }

    public String toString() {
        return "ProduceResponse{errorCode=" + this.errorCode + ", clusterId=" + this.clusterId + ", topicName=" + this.topicName + ", partitionId=" + this.partitionId + ", offset=" + this.offset + ", timestamp=" + this.timestamp + ", key=" + this.key + ", value=" + this.value + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProduceResponse) {
            ProduceResponse that = (ProduceResponse)o;
            return this.errorCode == that.getErrorCode() && this.clusterId.equals(that.getClusterId()) && this.topicName.equals(that.getTopicName()) && this.partitionId == that.getPartitionId() && this.offset == that.getOffset() && this.timestamp.equals(that.getTimestamp()) && this.key.equals(that.getKey()) && this.value.equals(that.getValue());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.errorCode;
        h$ *= 1000003;
        h$ ^= this.clusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.topicName.hashCode();
        h$ *= 1000003;
        h$ ^= this.partitionId;
        h$ *= 1000003;
        h$ ^= (int)(this.offset >>> 32 ^ this.offset);
        h$ *= 1000003;
        h$ ^= this.timestamp.hashCode();
        h$ *= 1000003;
        h$ ^= this.key.hashCode();
        h$ *= 1000003;
        return h$ ^= this.value.hashCode();
    }

    static final class Builder
    extends ProduceResponse.Builder {
        private Integer errorCode;
        private String clusterId;
        private String topicName;
        private Integer partitionId;
        private Long offset;
        private Optional<Instant> timestamp = Optional.empty();
        private Optional<ProduceResponse.ProduceResponseData> key = Optional.empty();
        private Optional<ProduceResponse.ProduceResponseData> value = Optional.empty();

        Builder() {
        }

        @Override
        public ProduceResponse.Builder setErrorCode(int errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public ProduceResponse.Builder setClusterId(String clusterId) {
            if (clusterId == null) {
                throw new NullPointerException("Null clusterId");
            }
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public ProduceResponse.Builder setTopicName(String topicName) {
            if (topicName == null) {
                throw new NullPointerException("Null topicName");
            }
            this.topicName = topicName;
            return this;
        }

        @Override
        public ProduceResponse.Builder setPartitionId(int partitionId) {
            this.partitionId = partitionId;
            return this;
        }

        @Override
        public ProduceResponse.Builder setOffset(long offset) {
            this.offset = offset;
            return this;
        }

        @Override
        public ProduceResponse.Builder setTimestamp(Optional<Instant> timestamp) {
            if (timestamp == null) {
                throw new NullPointerException("Null timestamp");
            }
            this.timestamp = timestamp;
            return this;
        }

        @Override
        public ProduceResponse.Builder setTimestamp(@Nullable Instant timestamp) {
            this.timestamp = Optional.ofNullable(timestamp);
            return this;
        }

        @Override
        public ProduceResponse.Builder setKey(Optional<ProduceResponse.ProduceResponseData> key) {
            if (key == null) {
                throw new NullPointerException("Null key");
            }
            this.key = key;
            return this;
        }

        @Override
        public ProduceResponse.Builder setKey(@Nullable ProduceResponse.ProduceResponseData key) {
            this.key = Optional.ofNullable(key);
            return this;
        }

        @Override
        public ProduceResponse.Builder setValue(Optional<ProduceResponse.ProduceResponseData> value) {
            if (value == null) {
                throw new NullPointerException("Null value");
            }
            this.value = value;
            return this;
        }

        @Override
        public ProduceResponse.Builder setValue(@Nullable ProduceResponse.ProduceResponseData value) {
            this.value = Optional.ofNullable(value);
            return this;
        }

        @Override
        public ProduceResponse build() {
            String missing = "";
            if (this.errorCode == null) {
                missing = missing + " errorCode";
            }
            if (this.clusterId == null) {
                missing = missing + " clusterId";
            }
            if (this.topicName == null) {
                missing = missing + " topicName";
            }
            if (this.partitionId == null) {
                missing = missing + " partitionId";
            }
            if (this.offset == null) {
                missing = missing + " offset";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ProduceResponse(this.errorCode, this.clusterId, this.topicName, this.partitionId, this.offset, this.timestamp, this.key, this.value);
        }
    }
}

