/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import io.confluent.kafkarest.common.CompletableFutures;
import io.confluent.kafkarest.common.KafkaFutures;
import io.confluent.kafkarest.controllers.BrokerManager;
import io.confluent.kafkarest.controllers.Entities;
import io.confluent.kafkarest.controllers.PartitionManager;
import io.confluent.kafkarest.controllers.ReplicaManager;
import io.confluent.kafkarest.entities.Broker;
import io.confluent.kafkarest.entities.Partition;
import io.confluent.kafkarest.entities.PartitionReplica;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.DescribeLogDirsOptions;
import org.apache.kafka.clients.admin.DescribeLogDirsResult;
import org.apache.kafka.common.KafkaFuture;

final class ReplicaManagerImpl
implements ReplicaManager {
    private final Admin adminClient;
    private final BrokerManager brokerManager;
    private final PartitionManager partitionManager;

    @Inject
    ReplicaManagerImpl(Admin adminClient, BrokerManager brokerManager, PartitionManager partitionManager) {
        this.adminClient = Objects.requireNonNull(adminClient);
        this.brokerManager = Objects.requireNonNull(brokerManager);
        this.partitionManager = Objects.requireNonNull(partitionManager);
    }

    @Override
    public CompletableFuture<List<PartitionReplica>> listReplicas(String clusterId, String topicName, int partitionId) {
        return ((CompletableFuture)this.partitionManager.getPartition(clusterId, topicName, partitionId).thenApply(partition -> (Partition)Entities.checkEntityExists(partition, "Partition %d of topic %s could not be found on cluster %s.", partitionId, topicName, clusterId))).thenApply(Partition::getReplicas);
    }

    @Override
    public CompletableFuture<Optional<PartitionReplica>> getReplica(String clusterId, String topicName, int partitionId, int brokerId) {
        return this.listReplicas(clusterId, topicName, partitionId).thenApply(replicas -> Entities.findEntityByKey(replicas, PartitionReplica::getBrokerId, brokerId));
    }

    @Override
    public CompletableFuture<List<PartitionReplica>> searchReplicasByBrokerId(String clusterId, int brokerId) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.brokerManager.getBroker(clusterId, brokerId).thenApply(broker -> (Broker)Entities.checkEntityExists(broker, "Broker %d cannot be found.", brokerId))).thenCompose(broker -> {
            DescribeLogDirsResult result = this.adminClient.describeLogDirs(Collections.singletonList(brokerId), new DescribeLogDirsOptions());
            return KafkaFutures.toCompletableFuture((KafkaFuture)result.values().get(brokerId));
        })).thenCompose(logDirs -> CompletableFutures.allAsList(logDirs.values().stream().flatMap(logDir -> logDir.replicaInfos.keySet().stream()).map(partition -> this.getReplica(clusterId, partition.topic(), partition.partition(), brokerId)).collect(Collectors.toList())))).thenApply(replicas -> replicas.stream().filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
    }
}

