/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import io.confluent.kafkarest.common.KafkaFutures;
import io.confluent.kafkarest.controllers.AclManager;
import io.confluent.kafkarest.controllers.ClusterManager;
import io.confluent.kafkarest.controllers.Entities;
import io.confluent.kafkarest.entities.Acl;
import io.confluent.kafkarest.entities.Cluster;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.resource.ResourcePattern;
import org.apache.kafka.common.resource.ResourcePatternFilter;

final class AclManagerImpl
implements AclManager {
    private final Admin adminClient;
    private final ClusterManager clusterManager;

    @Inject
    AclManagerImpl(Admin adminClient, ClusterManager clusterManager) {
        this.adminClient = Objects.requireNonNull(adminClient);
        this.clusterManager = Objects.requireNonNull(clusterManager);
    }

    @Override
    public CompletableFuture<List<Acl>> searchAcls(String clusterId, Acl.ResourceType resourceType, @Nullable String resourceName, Acl.PatternType patternType, @Nullable String principal, @Nullable String host, Acl.Operation operation, Acl.Permission permission) {
        AclBindingFilter aclBindingFilter = new AclBindingFilter(new ResourcePatternFilter(resourceType.toAdminResourceType(), resourceName, patternType.toAdminPatternType()), new AccessControlEntryFilter(principal, host, operation.toAclOperation(), permission.toAclPermissionType()));
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.clusterManager.getCluster(clusterId).thenApply(cluster -> (Cluster)Entities.checkEntityExists(cluster, "Cluster %s cannot be found.", clusterId))).thenApply(cluster -> this.adminClient.describeAcls(aclBindingFilter))).thenCompose(describeAclsResult -> KafkaFutures.toCompletableFuture(describeAclsResult.values()))).thenApply(aclBindings -> aclBindings.stream().map(aclBinding -> AclManagerImpl.toAcl(clusterId, aclBinding)).collect(Collectors.toList()));
    }

    @Override
    public CompletableFuture<Void> createAcl(String clusterId, Acl.ResourceType resourceType, String resourceName, Acl.PatternType patternType, String principal, String host, Acl.Operation operation, Acl.Permission permission) {
        AclBinding aclBinding = new AclBinding(new ResourcePattern(resourceType.toAdminResourceType(), resourceName, patternType.toAdminPatternType()), new AccessControlEntry(principal, host, operation.toAclOperation(), permission.toAclPermissionType()));
        return this.submitBindings(clusterId, Collections.singletonList(aclBinding));
    }

    @Override
    public CompletableFuture<Void> createAcls(String clusterId, List<Acl> acls) {
        List<AclBinding> aclBindings = acls.stream().map(acl -> new AclBinding(new ResourcePattern(acl.getResourceType().toAdminResourceType(), acl.getResourceName(), acl.getPatternType().toAdminPatternType()), new AccessControlEntry(acl.getPrincipal(), acl.getHost(), acl.getOperation().toAclOperation(), acl.getPermission().toAclPermissionType()))).collect(Collectors.toList());
        return this.submitBindings(clusterId, aclBindings);
    }

    @Override
    public CompletableFuture<List<Acl>> deleteAcls(String clusterId, Acl.ResourceType resourceType, String resourceName, Acl.PatternType patternType, String principal, String host, Acl.Operation operation, Acl.Permission permission) {
        AclBindingFilter aclBindingFilter = new AclBindingFilter(new ResourcePatternFilter(resourceType.toAdminResourceType(), resourceName, patternType.toAdminPatternType()), new AccessControlEntryFilter(principal, host, operation.toAclOperation(), permission.toAclPermissionType()));
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.clusterManager.getCluster(clusterId).thenApply(cluster -> (Cluster)Entities.checkEntityExists(cluster, "Cluster %s cannot be found.", clusterId))).thenApply(cluster -> this.adminClient.deleteAcls(Collections.singletonList(aclBindingFilter)))).thenCompose(deleteAclsResult -> KafkaFutures.toCompletableFuture((KafkaFuture)deleteAclsResult.values().get(aclBindingFilter)))).thenApply(filterResults -> filterResults.values().stream().map(DeleteAclsResult.FilterResult::binding).filter(Objects::nonNull).map(binding -> AclManagerImpl.toAcl(clusterId, binding)).collect(Collectors.toList()));
    }

    private static Acl toAcl(String clusterId, AclBinding aclBinding) {
        return Acl.fromAclBinding(aclBinding).setClusterId(clusterId).build();
    }

    private CompletableFuture<Void> submitBindings(String clusterId, List<AclBinding> aclBindings) {
        return ((CompletableFuture)((CompletableFuture)this.clusterManager.getCluster(clusterId).thenApply(cluster -> (Cluster)Entities.checkEntityExists(cluster, "Cluster %s cannot be found.", clusterId))).thenApply(cluster -> this.adminClient.createAcls((Collection)aclBindings))).thenCompose(createAclsResult -> {
            Collection results = createAclsResult.values().values();
            return CompletableFuture.allOf(results.stream().map(f -> KafkaFutures.toCompletableFuture(f)).collect(Collectors.toList()).toArray(new CompletableFuture[results.size()]));
        });
    }
}

