/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.controllers;

import io.confluent.kafkarest.common.KafkaFutures;
import io.confluent.kafkarest.controllers.ClusterManager;
import io.confluent.kafkarest.controllers.Entities;
import io.confluent.kafkarest.entities.AbstractConfig;
import io.confluent.kafkarest.entities.AlterConfigCommand;
import io.confluent.kafkarest.entities.Cluster;
import io.confluent.kafkarest.entities.ConfigSource;
import io.confluent.kafkarest.entities.ConfigSynonym;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.ws.rs.NotFoundException;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.DescribeConfigsOptions;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.config.ConfigResource;

abstract class AbstractConfigManager<T extends AbstractConfig, B extends AbstractConfig.Builder<T, B>> {
    private final Admin adminClient;
    private final ClusterManager clusterManager;

    AbstractConfigManager(Admin adminClient, ClusterManager clusterManager) {
        this.adminClient = Objects.requireNonNull(adminClient);
        this.clusterManager = Objects.requireNonNull(clusterManager);
    }

    final CompletableFuture<List<T>> listConfigs(String clusterId, ConfigResource resourceId, B prototype) {
        return this.listConfigs(clusterId, Collections.singletonList(resourceId), prototype).thenApply(result -> (List)result.get(resourceId));
    }

    final CompletableFuture<Map<ConfigResource, List<T>>> listConfigs(String clusterId, List<ConfigResource> resourceIds, B prototype) {
        return ((CompletableFuture)((CompletableFuture)this.clusterManager.getCluster(clusterId).thenApply(cluster -> (Cluster)Entities.checkEntityExists(cluster, "Cluster %s cannot be found.", clusterId))).thenCompose(cluster -> KafkaFutures.toCompletableFuture(this.adminClient.describeConfigs((Collection)resourceIds, new DescribeConfigsOptions().includeSynonyms(true)).all()))).thenApply(configsMap -> configsMap.entrySet().stream().collect(Collectors.toMap(e -> (ConfigResource)e.getKey(), e -> ((Config)e.getValue()).entries().stream().map(entry -> ((AbstractConfig.Builder)((AbstractConfig.Builder)((AbstractConfig.Builder)((AbstractConfig.Builder)((AbstractConfig.Builder)((AbstractConfig.Builder)((AbstractConfig.Builder)prototype.setName(entry.name())).setValue(entry.value())).setDefault(entry.isDefault())).setReadOnly(entry.isReadOnly())).setSensitive(entry.isSensitive())).setSource(ConfigSource.fromAdminConfigSource(entry.source()))).setSynonyms(entry.synonyms().stream().map(ConfigSynonym::fromAdminConfigSynonym).collect(Collectors.toList()))).build()).collect(Collectors.toList()))));
    }

    final CompletableFuture<Optional<T>> getConfig(String clusterId, ConfigResource resourceId, B prototype, String name) {
        return this.listConfigs(clusterId, resourceId, prototype).thenApply(configs -> Entities.findEntityByKey(configs, AbstractConfig::getName, name));
    }

    final CompletableFuture<Void> safeUpdateConfig(String clusterId, ConfigResource resourceId, B prototype, String name, String newValue) {
        return ((CompletableFuture)this.getConfig(clusterId, resourceId, prototype, name).thenApply(config -> (AbstractConfig)Entities.checkEntityExists(config, "Config %s cannot be found for %s %s in cluster %s.", name, resourceId.type(), resourceId.name(), clusterId))).thenCompose(config -> this.alterConfigs(resourceId, Collections.singletonList(AlterConfigCommand.set(name, newValue))));
    }

    final CompletableFuture<Void> unsafeUpdateConfig(String clusterId, ConfigResource resourceId, String name, String newValue) {
        return ((CompletableFuture)this.clusterManager.getCluster(clusterId).thenApply(cluster -> (Cluster)Entities.checkEntityExists(cluster, "Cluster %s cannot be found.", clusterId))).thenCompose(cluster -> this.alterConfigs(resourceId, Collections.singletonList(AlterConfigCommand.set(name, newValue))));
    }

    final CompletableFuture<Void> safeResetConfig(String clusterId, ConfigResource resourceId, B prototype, String name) {
        return ((CompletableFuture)this.getConfig(clusterId, resourceId, prototype, name).thenApply(config -> (AbstractConfig)Entities.checkEntityExists(config, "Config %s cannot be found for %s %s in cluster %s.", name, resourceId.type(), resourceId.name(), clusterId))).thenCompose(config -> this.alterConfigs(resourceId, Collections.singletonList(AlterConfigCommand.delete(name))));
    }

    final CompletableFuture<Void> unsafeResetConfig(String clusterId, ConfigResource resourceId, String name) {
        return ((CompletableFuture)this.clusterManager.getCluster(clusterId).thenApply(cluster -> (Cluster)Entities.checkEntityExists(cluster, "Cluster %s cannot be found.", clusterId))).thenCompose(cluster -> this.alterConfigs(resourceId, Collections.singletonList(AlterConfigCommand.delete(name))));
    }

    final CompletableFuture<Void> safeAlterConfigs(String clusterId, ConfigResource resourceId, B prototype, List<AlterConfigCommand> commands) {
        return ((CompletableFuture)this.listConfigs(clusterId, resourceId, prototype).thenApply(configs -> {
            Set configNames = configs.stream().map(AbstractConfig::getName).collect(Collectors.toSet());
            for (AlterConfigCommand command : commands) {
                if (configNames.contains(command.getName())) continue;
                throw new NotFoundException(String.format("Config %s cannot be found for %s %s in cluster %s.", command.getName(), resourceId.type(), resourceId.name(), clusterId));
            }
            return configs;
        })).thenCompose(config -> this.alterConfigs(resourceId, commands));
    }

    final CompletableFuture<Void> unsafeAlterConfigs(String clusterId, ConfigResource resourceId, List<AlterConfigCommand> commands) {
        return ((CompletableFuture)this.clusterManager.getCluster(clusterId).thenApply(cluster -> (Cluster)Entities.checkEntityExists(cluster, "Cluster %s cannot be found.", clusterId))).thenCompose(cluster -> this.alterConfigs(resourceId, commands));
    }

    private CompletableFuture<Void> alterConfigs(ConfigResource resourceId, List<AlterConfigCommand> commands) {
        return KafkaFutures.toCompletableFuture((KafkaFuture)this.adminClient.incrementalAlterConfigs(Collections.singletonMap(resourceId, commands.stream().map(AlterConfigCommand::toAlterConfigOp).collect(Collectors.toList()))).values().get(resourceId));
    }
}

