/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.protobuf;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.google.common.collect.ImmutableList;
import com.squareup.wire.Syntax;
import com.squareup.wire.schema.Field;
import com.squareup.wire.schema.Location;
import com.squareup.wire.schema.internal.parser.EnumConstantElement;
import com.squareup.wire.schema.internal.parser.EnumElement;
import com.squareup.wire.schema.internal.parser.ExtendElement;
import com.squareup.wire.schema.internal.parser.ExtensionsElement;
import com.squareup.wire.schema.internal.parser.FieldElement;
import com.squareup.wire.schema.internal.parser.MessageElement;
import com.squareup.wire.schema.internal.parser.OneOfElement;
import com.squareup.wire.schema.internal.parser.OptionElement;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import com.squareup.wire.schema.internal.parser.ReservedElement;
import com.squareup.wire.schema.internal.parser.RpcElement;
import com.squareup.wire.schema.internal.parser.ServiceElement;
import com.squareup.wire.schema.internal.parser.TypeElement;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.ranges.IntRange;

public class ProtoFileElementDeserializer
extends StdDeserializer<ProtoFileElement> {
    private static final ObjectMapper mapper = JacksonMapper.INSTANCE;

    public ProtoFileElementDeserializer() {
        this(null);
    }

    public ProtoFileElementDeserializer(Class<?> vc) {
        super(vc);
    }

    public ProtoFileElement deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        return this.toProtoFile(node);
    }

    private ProtoFileElement toProtoFile(JsonNode node) throws JsonProcessingException {
        ImmutableList.Builder typeElementBuilder = ImmutableList.builder();
        for (Object typeNode : node.get("types")) {
            typeElementBuilder.add((Object)this.toType((JsonNode)typeNode));
        }
        ImmutableList.Builder serviceElementBuilder = ImmutableList.builder();
        for (Object serviceNode : node.get("services")) {
            serviceElementBuilder.add((Object)this.toService((JsonNode)serviceNode));
        }
        ImmutableList.Builder extendElementBuilder = ImmutableList.builder();
        for (JsonNode extendNode : node.get("extendDeclarations")) {
            extendElementBuilder.add((Object)this.toExtend(extendNode));
        }
        ImmutableList.Builder optionElementBuilder = ImmutableList.builder();
        for (JsonNode optionNode : node.get("options")) {
            optionElementBuilder.add((Object)this.toOption(optionNode));
        }
        return new ProtoFileElement(this.toLocation(node.get("location")), node.get("packageName").asText(), Syntax.valueOf((String)node.get("syntax").asText()), Arrays.asList((String[])mapper.convertValue((Object)node.get("imports"), String[].class)), Arrays.asList((String[])mapper.convertValue((Object)node.get("publicImports"), String[].class)), Arrays.asList((String[])mapper.convertValue((Object)node.get("weakImports"), String[].class)), (List)typeElementBuilder.build(), (List)serviceElementBuilder.build(), (List)extendElementBuilder.build(), (List)optionElementBuilder.build());
    }

    private TypeElement toType(JsonNode node) throws JsonProcessingException {
        if (node.has("constants")) {
            return this.toEnum(node);
        }
        return this.toMessage(node);
    }

    private MessageElement toMessage(JsonNode node) throws JsonProcessingException {
        ImmutableList.Builder typeElementBuilder = ImmutableList.builder();
        for (Object typeNode : node.get("nestedTypes")) {
            typeElementBuilder.add((Object)this.toType((JsonNode)typeNode));
        }
        ImmutableList.Builder optionElementBuilder = ImmutableList.builder();
        for (Object optionNode : node.get("options")) {
            optionElementBuilder.add((Object)this.toOption((JsonNode)optionNode));
        }
        ImmutableList.Builder reservedElementBuilder = ImmutableList.builder();
        for (Object reservedNode : node.get("reserveds")) {
            reservedElementBuilder.add((Object)this.toReserved((JsonNode)reservedNode));
        }
        ImmutableList.Builder fieldElementBuilder = ImmutableList.builder();
        for (Object fieldNode : node.get("fields")) {
            fieldElementBuilder.add((Object)this.toField((JsonNode)fieldNode));
        }
        ImmutableList.Builder oneOfElementBuilder = ImmutableList.builder();
        for (Object oneOfNode : node.get("oneOfs")) {
            oneOfElementBuilder.add((Object)this.toOneOf((JsonNode)oneOfNode));
        }
        ImmutableList.Builder extensionsElementBuilder = ImmutableList.builder();
        for (JsonNode extensionNode : node.get("extensions")) {
            extensionsElementBuilder.add((Object)this.toExtensions(extensionNode));
        }
        ImmutableList.Builder extendElementBuilder = ImmutableList.builder();
        for (JsonNode extendNode : node.get("extendDeclarations")) {
            extendElementBuilder.add((Object)this.toExtend(extendNode));
        }
        return new MessageElement(this.toLocation(node.get("location")), node.get("name").asText(), node.get("documentation").asText(), (List)typeElementBuilder.build(), (List)optionElementBuilder.build(), (List)reservedElementBuilder.build(), (List)fieldElementBuilder.build(), (List)oneOfElementBuilder.build(), (List)extensionsElementBuilder.build(), Collections.emptyList(), (List)extendElementBuilder.build());
    }

    private OneOfElement toOneOf(JsonNode node) throws JsonProcessingException {
        ImmutableList.Builder fieldElementBuilder = ImmutableList.builder();
        for (JsonNode fieldNode : node.get("fields")) {
            fieldElementBuilder.add((Object)this.toField(fieldNode));
        }
        ImmutableList.Builder optionElementBuilder = ImmutableList.builder();
        for (JsonNode optionNode : node.get("options")) {
            optionElementBuilder.add((Object)this.toOption(optionNode));
        }
        return new OneOfElement(node.get("name").asText(), node.get("documentation").asText(), (List)fieldElementBuilder.build(), Collections.emptyList(), (List)optionElementBuilder.build(), ProtobufSchema.DEFAULT_LOCATION);
    }

    private ExtensionsElement toExtensions(JsonNode node) throws JsonProcessingException {
        ImmutableList.Builder valueBuilder = ImmutableList.builder();
        for (JsonNode value : node.get("values")) {
            if (value.isInt()) {
                valueBuilder.add((Object)value.asInt());
                continue;
            }
            valueBuilder.add((Object)new IntRange(value.get("start").asInt(), value.get("endInclusive").asInt()));
        }
        ImmutableList.Builder optionElementBuilder = ImmutableList.builder();
        for (JsonNode optionNode : node.get("options")) {
            optionElementBuilder.add((Object)this.toOption(optionNode));
        }
        return new ExtensionsElement(this.toLocation(node.get("location")), node.get("documentation").asText(), (List)valueBuilder.build(), (List)optionElementBuilder.build());
    }

    private EnumElement toEnum(JsonNode node) throws JsonProcessingException {
        ImmutableList.Builder optionElementBuilder = ImmutableList.builder();
        for (Object optionNode : node.get("options")) {
            optionElementBuilder.add((Object)this.toOption((JsonNode)optionNode));
        }
        ImmutableList.Builder enumConstantElementBuilder = ImmutableList.builder();
        for (JsonNode enumConstantNode : node.get("constants")) {
            enumConstantElementBuilder.add((Object)this.toEnumConstant(enumConstantNode));
        }
        ImmutableList.Builder reservedElementBuilder = ImmutableList.builder();
        for (JsonNode reservedNode : node.get("reserveds")) {
            reservedElementBuilder.add((Object)this.toReserved(reservedNode));
        }
        return new EnumElement(this.toLocation(node.get("location")), node.get("name").asText(), node.get("documentation").asText(), (List)optionElementBuilder.build(), (List)enumConstantElementBuilder.build(), (List)reservedElementBuilder.build());
    }

    private EnumConstantElement toEnumConstant(JsonNode node) throws JsonProcessingException {
        ImmutableList.Builder optionElementBuilder = ImmutableList.builder();
        for (JsonNode optionNode : node.get("options")) {
            optionElementBuilder.add((Object)this.toOption(optionNode));
        }
        return new EnumConstantElement(this.toLocation(node.get("location")), node.get("name").asText(), node.get("tag").asInt(), node.get("documentation").asText(), (List)optionElementBuilder.build());
    }

    private FieldElement toField(JsonNode node) throws JsonProcessingException {
        ImmutableList.Builder optionElementBuilder = ImmutableList.builder();
        for (JsonNode optionNode : node.get("options")) {
            optionElementBuilder.add((Object)this.toOption(optionNode));
        }
        return new FieldElement(this.toLocation(node.get("location")), this.toLabel(node.get("label")), node.get("type").asText(), node.get("name").asText(), this.nodeToString(node.get("defaultValue")), this.nodeToString(node.get("jsonName")), node.get("tag").asInt(), node.get("documentation").asText(), (List)optionElementBuilder.build());
    }

    private ReservedElement toReserved(JsonNode node) {
        ImmutableList.Builder valueBuilder = ImmutableList.builder();
        for (JsonNode value : node.get("values")) {
            if (value.isInt()) {
                valueBuilder.add((Object)value.asInt());
                continue;
            }
            if (value.isTextual()) {
                valueBuilder.add((Object)value.asText());
                continue;
            }
            valueBuilder.add((Object)new IntRange(value.get("start").asInt(), value.get("endInclusive").asInt()));
        }
        return new ReservedElement(this.toLocation(node.get("location")), node.get("documentation").asText(), (List)valueBuilder.build());
    }

    private ExtendElement toExtend(JsonNode node) throws JsonProcessingException {
        ImmutableList.Builder fieldElementBuilder = ImmutableList.builder();
        for (JsonNode fieldNode : node.get("fields")) {
            fieldElementBuilder.add((Object)this.toField(fieldNode));
        }
        return new ExtendElement(this.toLocation(node.get("location")), node.get("name").asText(), node.get("documentation").asText(), (List)fieldElementBuilder.build());
    }

    private ServiceElement toService(JsonNode node) throws JsonProcessingException {
        ImmutableList.Builder rpcElementBuilder = ImmutableList.builder();
        for (JsonNode optionNode : node.get("rpcs")) {
            rpcElementBuilder.add((Object)this.toRpc(optionNode));
        }
        ImmutableList.Builder optionElementBuilder = ImmutableList.builder();
        for (JsonNode optionNode : node.get("options")) {
            optionElementBuilder.add((Object)this.toOption(optionNode));
        }
        return new ServiceElement(this.toLocation(node.get("location")), node.get("name").asText(), node.get("documentation").asText(), (List)rpcElementBuilder.build(), (List)optionElementBuilder.build());
    }

    private RpcElement toRpc(JsonNode node) throws JsonProcessingException {
        ImmutableList.Builder optionElementBuilder = ImmutableList.builder();
        for (JsonNode optionNode : node.get("options")) {
            optionElementBuilder.add((Object)this.toOption(optionNode));
        }
        return new RpcElement(this.toLocation(node.get("location")), node.get("name").asText(), node.get("documentation").asText(), node.get("requestType").asText(), node.get("responseType").asText(), node.get("requestStreaming").asBoolean(), node.get("responseStreaming").asBoolean(), (List)optionElementBuilder.build());
    }

    private OptionElement toOption(JsonNode node) throws JsonProcessingException {
        OptionElement.Kind kind = OptionElement.Kind.valueOf((String)node.get("kind").asText());
        Object value = null;
        JsonNode valueNode = node.get("value");
        switch (kind) {
            case ENUM: 
            case STRING: 
            case NUMBER: {
                value = valueNode.asText();
                break;
            }
            case BOOLEAN: {
                value = valueNode.asBoolean();
                break;
            }
            case MAP: {
                value = this.toOptionMap(valueNode);
                break;
            }
            case LIST: {
                value = mapper.readValue(valueNode.toString(), (TypeReference)new TypeReference<ArrayList<String>>(){});
                break;
            }
            case OPTION: {
                value = this.toOption(valueNode);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Unknown kind '%s' of given option node.", node.get("kind").asText()));
            }
        }
        return new OptionElement(node.get("name").asText(), OptionElement.Kind.valueOf((String)node.get("kind").asText()), value, node.get("parenthesized").asBoolean());
    }

    private Map<String, Object> toOptionMap(JsonNode node) {
        LinkedHashMap<String, Object> optionsMap = new LinkedHashMap<String, Object>();
        Iterator optionsIter = node.fieldNames();
        while (optionsIter.hasNext()) {
            String option = (String)optionsIter.next();
            JsonNode optionEntryNode = node.get(option);
            optionsMap.put(option, this.toNestedValue(optionEntryNode));
        }
        return optionsMap;
    }

    private Object toNestedValue(JsonNode node) {
        OptionElement.OptionPrimitive primitiveValue = this.getOptionPrimitive(node);
        if (primitiveValue != null) {
            return primitiveValue;
        }
        switch (node.getNodeType()) {
            case STRING: {
                return node.textValue();
            }
            case NUMBER: {
                return node.numberValue();
            }
            case BOOLEAN: {
                return node.booleanValue();
            }
            case ARRAY: {
                ArrayList<Object> nestedList = new ArrayList<Object>();
                Iterator arrayIter = node.elements();
                while (arrayIter.hasNext()) {
                    nestedList.add(this.toNestedValue((JsonNode)arrayIter.next()));
                }
                return nestedList;
            }
            case OBJECT: {
                return this.toOptionMap(node);
            }
        }
        return null;
    }

    private OptionElement.OptionPrimitive getOptionPrimitive(JsonNode node) {
        String kind;
        if (node.has("kind") && ("NUMBER".equals(kind = node.get("kind").asText()) || "ENUM".equals(kind) || "BOOLEAN".equals(kind))) {
            return new OptionElement.OptionPrimitive(OptionElement.Kind.valueOf((String)kind), (Object)node.get("value").asText());
        }
        return null;
    }

    private Location toLocation(JsonNode node) {
        return new Location(node.get("base").asText(), node.get("path").asText(), node.get("line").asInt(), node.get("column").asInt());
    }

    private Field.Label toLabel(JsonNode node) {
        return node.isNull() ? null : Field.Label.valueOf((String)node.asText());
    }

    private String nodeToString(JsonNode node) {
        return node.isNull() ? null : node.asText();
    }
}

