/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.jms;

import io.confluent.kafka.jms.InvalidLicenseException;
import io.confluent.kafka.jms.JMSClientConfig;
import io.confluent.kafka.jms.KafkaConnection;
import io.confluent.kafka.jms.KafkaQueueConnection;
import io.confluent.kafka.jms.KafkaTopicConnection;
import io.confluent.kafka.jms.Unsupported;
import io.confluent.license.LicenseManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import org.apache.kafka.common.utils.Time;

public class KafkaConnectionFactory
implements ConnectionFactory,
TopicConnectionFactory,
QueueConnectionFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    JMSClientConfig config;
    LicenseManager licenseManager;
    Time time;

    private synchronized LicenseManager getLicenseManager() {
        if (this.licenseManager == null) {
            this.licenseManager = new LicenseManager(this.config.confluentTopic, this.config.producer, this.config.consumer, this.config.adminClient);
        }
        return this.licenseManager;
    }

    KafkaConnectionFactory(JMSClientConfig config) {
        this.config = config;
        this.licenseManager = null;
    }

    public KafkaConnectionFactory(Map<String, Object> settings) {
        this(new JMSClientConfig(settings));
    }

    public KafkaConnectionFactory(Properties properties) {
        this(new JMSClientConfig(properties));
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        this.config = new JMSClientConfig((Map)ois.readObject());
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(new HashMap(this.config.originals()));
    }

    private void validateLicense() throws InvalidLicenseException {
        try {
            this.getLicenseManager().registerOrValidateLicense(this.config.license);
        }
        catch (io.confluent.license.InvalidLicenseException e) {
            throw new InvalidLicenseException(e);
        }
    }

    public Connection createConnection() throws JMSException {
        this.validateLicense();
        return new KafkaConnection(this.config);
    }

    @Unsupported(value="Creation of connections with credentials specified at runtime is not implemented.")
    public Connection createConnection(String username, String password) throws JMSException {
        if (!this.config.enableCreateConnectionIgnoreAuthenticate) {
            throw new JMSException("Creation of connections with credentials specified at runtime is not implemented.");
        }
        return this.createConnection();
    }

    public QueueConnection createQueueConnection() throws JMSException {
        this.validateLicense();
        return new KafkaQueueConnection(this.config);
    }

    @Unsupported(value="Creation of connections with credentials specified at runtime is not implemented.")
    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        if (!this.config.enableCreateConnectionIgnoreAuthenticate) {
            throw new JMSException("Creation of connections with credentials specified at runtime is not implemented.");
        }
        return this.createQueueConnection();
    }

    public TopicConnection createTopicConnection() throws JMSException {
        this.validateLicense();
        return new KafkaTopicConnection(this.config);
    }

    @Unsupported(value="Creation of connections with credentials specified at runtime is not implemented.")
    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        if (!this.config.enableCreateConnectionIgnoreAuthenticate) {
            throw new JMSException("Creation of connections with credentials specified at runtime is not implemented.");
        }
        return this.createTopicConnection();
    }
}

