/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.jms;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NamingException;

class JNDIPreconditions {
    static final Set<String> RESERVED_NAMES = ImmutableSet.of((Object)"topic", (Object)"queue");

    JNDIPreconditions() {
    }

    public static void checkNotEmpty(Name name) throws NamingException {
        JNDIPreconditions.checkName(name);
        if (name.isEmpty()) {
            throw new InvalidNameException("name cannot be empty");
        }
    }

    public static void checkName(Name name) throws NamingException {
        JNDIPreconditions.checkName(name, "name", false);
    }

    public static void checkName(Name name, String variable) throws NamingException {
        JNDIPreconditions.checkName(name, variable, false);
    }

    public static void checkName(Name name, String variable, boolean prefix) throws NamingException {
        if (null == name) {
            throw new InvalidNameException(String.format("%s cannot be null.", variable));
        }
        if (RESERVED_NAMES.contains(name.toString()) && !prefix) {
            throw new InvalidNameException(String.format("%s cannot use the reserved name '%s'.", variable, name));
        }
    }

    public static void checkName(String name) throws NamingException {
        JNDIPreconditions.checkName(name, "name", false);
    }

    public static void checkName(String name, String variable) throws NamingException {
        JNDIPreconditions.checkName(name, variable, false);
    }

    public static void checkName(String name, String variable, boolean prefix) throws NamingException {
        if (null == name) {
            throw new InvalidNameException(String.format("%s cannot be null.", variable));
        }
        if (RESERVED_NAMES.contains(name) && !prefix) {
            throw new InvalidNameException(String.format("%s cannot use the reserved name '%s'.", variable, name));
        }
    }
}

