/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.jms;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;

public class JMSClientConfig
extends AbstractConfig {
    static final ConfigDef CONFIG;
    static final Set<String> SSL_SASL_CONFIGS;
    public static final String BOOTSTRAP_SERVERS_CONFIG = "bootstrap.servers";
    public static final String CLIENT_ID_CONFIG = "client.id";
    public static final String SECURITY_PROTOCOL_CONFIG = "security.protocol";
    public static final String CONSUMER_GROUP_ID_CONFIG = "consumer.group.id";
    public static final String CONSUMER_MAX_POLL_RECORDS_CONF = "consumer.max.poll.records";
    public static final String CONSUMER_MAX_POLL_RECORDS_DOC = "The maximum number of records returned in a single call to poll().";
    public static final String CONSUMER_POLL_TIMEOUT_MS_CONF = "jms.consumer.poll.timeout.ms";
    static final String CONSUMER_POLL_TIMEOUT_MS_DOC = "The amount of time to block on consumer.poll when retrieving records from Kafka.";
    public static final String CONSUMER_CLOSE_TIMEOUT_MS_CONF = "jms.consumer.close.timeout.ms";
    public static final String CONSUMER_CLOSE_TIMEOUT_MS_DOC = "The amount of time in milliseconds to wait when closing a MessageConsumer.";
    public static final String MESSAGE_LISTENER_MAX_REDELIVERIES_CONF = "message.listener.max.redeliveries";
    static final String MESSAGE_LISTENER_MAX_REDELIVERIES_DOC = "Maximum number of times a message will be redelivered to a MessageConsumer listener when the session is in AUTO_ACKNOWLEDGE mode.";
    public static final String MESSAGE_LISTENER_NULL_WAIT_MS_CONF = "message.listener.null.wait.ms";
    static final String MESSAGE_LISTENER_NULL_WAIT_MS_DOC = "Amount of time to wait if no messages are returned by their associated MessageConsumer(s).";
    public static final String CONNECTION_STOP_TIMEOUT_MS_CONF = "connection.stop.timeout.ms";
    static final String CONNECTION_STOP_TIMEOUT_MS_DOC = "The number of milliseconds to wait for the message listener threads to finish when connection.stop() has been called.";
    public static final String CONFLUENT_LICENSE_CONF = "confluent.license";
    static final String CONFLUENT_LICENSE_DOC = "Confluent issues a license key to each customer. The license key is a short snippet of text that you can copy and paste. Without the license key, you can use the client for a 30-day trial period. If you are a subscriber, please contact Confluent Support for more information.";
    static final String CONFLUENT_LICENSE_DEFAULT = "";
    public static final String CONFLUENT_TOPIC_CONF = "confluent.topic";
    public static final String CONFLUENT_TOPIC_DEFAULT = "_confluent-command";
    public static final String CONFLUENT_TOPIC_DOC = "Name of the Kafka topic used for Confluent Platform configuration, including licensing information.";
    public static final String CONFLUENT_TOPIC_REPLICATION_FACTOR_CONF = "confluent.topic.replication.factor";
    public static final String CONFLUENT_TOPIC_REPLICATION_FACTOR_DOC = "The replication factor for the Kafka topic used for Confluent Platform configuration, including licensing information. This is used only if the topic does not already exist, and the default of 3 is appropriate for production use. If you are using a development environment with less than 3 brokers, you must set this to the number of brokers (often 1).";
    public static final int CONFLUENT_TOPIC_REPLICATION_FACTOR_DEFAULT = 3;
    public static final String FALLBACK_MESSAGE_TYPE_CONF = "jms.fallback.message.type";
    public static final String FALLBACK_MESSAGE_TYPE_DOC = "If the jms.message.type header is not specified, fallback to this message type.";
    public static final String ALLOW_OUT_OF_ORDER_ACKNOWLEDGE_CONF = "allow.out.of.order.acknowledge";
    public static final String ALLOW_OUT_OF_ORDER_ACKNOWLEDGE_DOC = "If true, does not throw an exception if a message is acknowledged out of order (which implicitly acknowledges any messages before it). default value is false.";
    public static final String CREATE_CONNECTION_IGNORE_AUTHENTICATE_CONF = "jms.create.connection.ignore.authenticate";
    public static final String CREATE_CONNECTION_IGNORE_AUTHENTICATE_DOC = "If true, connection creation methods on ConnectionFactory that have username and password parameters will fall through to the corresponding methods that do not have these parameters (the parameters will be ignored). If false, use of these methods will result in a JMSException being thrown.";
    public final Map<String, Object> consumer;
    public final Map<String, Object> producer;
    public final Map<String, Object> adminClient;
    public final long consumerPollTimeoutMs;
    public final int consumerMaxPollRecords;
    public final String clientID;
    public final int messageListenerNullWait;
    public final int messageListenerMaxRedeliveries;
    public final int connectionStopTimeoutMs;
    public final String license = this.getString("confluent.license");
    public final String confluentTopic = this.getString("confluent.topic");
    public final int confluentTopicReplicationFactor = this.getInt("confluent.topic.replication.factor");
    public final String fallbackMessageType;
    public final boolean allowOutOfOrderAcknowledge;
    public final int consumerCloseTimeoutMs = this.getInt("jms.consumer.close.timeout.ms");
    public final boolean enableCreateConnectionIgnoreAuthenticate;

    static final Map<String, Object> copy(Properties properties) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (Map.Entry<Object, Object> kvp : properties.entrySet()) {
            result.put(kvp.getKey().toString(), kvp.getValue());
        }
        return result;
    }

    public JMSClientConfig(Properties properties) {
        this(JMSClientConfig.copy(properties));
    }

    public JMSClientConfig(Map<String, Object> settings) {
        super(CONFIG, settings, false);
        this.consumerPollTimeoutMs = this.getLong(CONSUMER_POLL_TIMEOUT_MS_CONF);
        this.consumerMaxPollRecords = this.getInt(CONSUMER_MAX_POLL_RECORDS_CONF);
        this.messageListenerMaxRedeliveries = this.getInt(MESSAGE_LISTENER_MAX_REDELIVERIES_CONF);
        this.messageListenerNullWait = this.getInt(MESSAGE_LISTENER_NULL_WAIT_MS_CONF);
        this.connectionStopTimeoutMs = this.getInt(CONNECTION_STOP_TIMEOUT_MS_CONF);
        this.fallbackMessageType = this.getString(FALLBACK_MESSAGE_TYPE_CONF);
        this.allowOutOfOrderAcknowledge = this.getBoolean(ALLOW_OUT_OF_ORDER_ACKNOWLEDGE_CONF);
        this.enableCreateConnectionIgnoreAuthenticate = this.getBoolean(CREATE_CONNECTION_IGNORE_AUTHENTICATE_CONF);
        List bootstrapServerList = this.getList(BOOTSTRAP_SERVERS_CONFIG);
        String bootstrapServers = Joiner.on((String)",").join((Iterable)bootstrapServerList);
        this.clientID = this.getString(CLIENT_ID_CONFIG);
        String securityProtocol = this.getString(SECURITY_PROTOCOL_CONFIG);
        HashMap<String, Object> consumer = new HashMap<String, Object>();
        consumer.put(BOOTSTRAP_SERVERS_CONFIG, bootstrapServers);
        consumer.put(CLIENT_ID_CONFIG, this.clientID);
        consumer.put(SECURITY_PROTOCOL_CONFIG, securityProtocol);
        for (String string : SSL_SASL_CONFIGS) {
            Object configValue = this.get(string);
            if (configValue == null) continue;
            consumer.put(string, configValue);
        }
        consumer.put("key.deserializer", ByteArrayDeserializer.class.getName());
        consumer.put("value.deserializer", ByteArrayDeserializer.class.getName());
        consumer.put("max.poll.records", this.consumerMaxPollRecords);
        consumer.put("enable.auto.commit", false);
        Map consumerConfig = this.originalsWithPrefix("consumer.");
        for (Object consumerKey : consumerConfig.keySet()) {
            consumer.put((String)consumerKey, consumerConfig.get(consumerKey));
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(BOOTSTRAP_SERVERS_CONFIG, bootstrapServers);
        hashMap.put(CLIENT_ID_CONFIG, this.clientID);
        hashMap.put(SECURITY_PROTOCOL_CONFIG, securityProtocol);
        for (String string : SSL_SASL_CONFIGS) {
            Object configValue = this.get(string);
            if (configValue == null) continue;
            hashMap.put(string, configValue);
        }
        hashMap.put("key.serializer", ByteArraySerializer.class.getName());
        hashMap.put("value.serializer", ByteArraySerializer.class.getName());
        Map producerConfig = this.originalsWithPrefix("producer.");
        for (String producerKey : producerConfig.keySet()) {
            hashMap.put(producerKey, producerConfig.get(producerKey));
        }
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap2.put(BOOTSTRAP_SERVERS_CONFIG, bootstrapServers);
        hashMap2.put(CLIENT_ID_CONFIG, this.clientID);
        hashMap2.put(SECURITY_PROTOCOL_CONFIG, securityProtocol);
        hashMap2.put("replication.factor", Integer.toString(this.confluentTopicReplicationFactor));
        for (String configKey : SSL_SASL_CONFIGS) {
            Object configValue = this.get(configKey);
            if (configValue == null) continue;
            hashMap2.put(configKey, configValue);
        }
        this.consumer = ImmutableMap.copyOf(consumer);
        this.producer = ImmutableMap.copyOf(hashMap);
        this.adminClient = ImmutableMap.copyOf(hashMap2);
    }

    static {
        ConfigDef configDef = new ConfigDef().define(BOOTSTRAP_SERVERS_CONFIG, ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, "A list of host/port pairs to use for establishing the initial connection to the Kafka cluster. The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers. This list should be in the form <code>host1:port1,host2:port2,...</code>. Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).").define(CLIENT_ID_CONFIG, ConfigDef.Type.STRING, ConfigDef.Importance.MEDIUM, "An id string to pass to the server when making requests. The purpose of this is to be able to track the source of requests beyond just ip/port by allowing a logical application name to be included in server-side request logging.").define(SECURITY_PROTOCOL_CONFIG, ConfigDef.Type.STRING, (Object)"PLAINTEXT", ConfigDef.Importance.LOW, CommonClientConfigs.SECURITY_PROTOCOL_DOC).define(CONSUMER_MAX_POLL_RECORDS_CONF, ConfigDef.Type.INT, (Object)1024, ConfigDef.Importance.MEDIUM, CONSUMER_MAX_POLL_RECORDS_DOC).define(CONFLUENT_LICENSE_CONF, ConfigDef.Type.STRING, (Object)CONFLUENT_LICENSE_DEFAULT, ConfigDef.Importance.HIGH, CONFLUENT_LICENSE_DOC).define(CONFLUENT_TOPIC_CONF, ConfigDef.Type.STRING, (Object)CONFLUENT_TOPIC_DEFAULT, ConfigDef.Importance.HIGH, CONFLUENT_TOPIC_DOC).define(CONFLUENT_TOPIC_REPLICATION_FACTOR_CONF, ConfigDef.Type.INT, (Object)3, ConfigDef.Importance.LOW, CONFLUENT_TOPIC_REPLICATION_FACTOR_DOC).define(CONSUMER_POLL_TIMEOUT_MS_CONF, ConfigDef.Type.LONG, (Object)10000L, ConfigDef.Importance.MEDIUM, CONSUMER_POLL_TIMEOUT_MS_DOC).define(MESSAGE_LISTENER_MAX_REDELIVERIES_CONF, ConfigDef.Type.INT, (Object)10, ConfigDef.Importance.LOW, MESSAGE_LISTENER_MAX_REDELIVERIES_DOC).define(MESSAGE_LISTENER_NULL_WAIT_MS_CONF, ConfigDef.Type.INT, (Object)1000, ConfigDef.Importance.LOW, MESSAGE_LISTENER_NULL_WAIT_MS_DOC).define(CONNECTION_STOP_TIMEOUT_MS_CONF, ConfigDef.Type.INT, (Object)30000, ConfigDef.Importance.LOW, CONNECTION_STOP_TIMEOUT_MS_DOC).define(FALLBACK_MESSAGE_TYPE_CONF, ConfigDef.Type.STRING, (Object)"text", (ConfigDef.Validator)ConfigDef.ValidString.in((String[])new String[]{"text", "bytes", "stream", "map", "object"}), ConfigDef.Importance.MEDIUM, FALLBACK_MESSAGE_TYPE_DOC).define(ALLOW_OUT_OF_ORDER_ACKNOWLEDGE_CONF, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, ALLOW_OUT_OF_ORDER_ACKNOWLEDGE_DOC).define(CONSUMER_CLOSE_TIMEOUT_MS_CONF, ConfigDef.Type.INT, (Object)30000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)10000), ConfigDef.Importance.LOW, CONSUMER_CLOSE_TIMEOUT_MS_DOC).define(CREATE_CONNECTION_IGNORE_AUTHENTICATE_CONF, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, CREATE_CONNECTION_IGNORE_AUTHENTICATE_DOC);
        ImmutableSet beforeSslSasl = ImmutableSet.copyOf((Collection)configDef.names());
        configDef.withClientSslSupport().withClientSaslSupport();
        ImmutableSet afterSslSasl = ImmutableSet.copyOf((Collection)configDef.names());
        SSL_SASL_CONFIGS = ImmutableSet.copyOf((Collection)Sets.difference((Set)afterSslSasl, (Set)beforeSslSasl));
        CONFIG = configDef;
    }
}

