/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.jms;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.confluent.kafka.jms.KafkaMessageConsumer;
import io.confluent.kafka.jms.KafkaMessageProducer;
import io.confluent.kafka.jms.KafkaSession;
import java.util.Collection;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ClientState {
    static final Logger log = LoggerFactory.getLogger(ClientState.class);
    Multimap<KafkaSession, KafkaMessageConsumer> consumers = HashMultimap.create();
    Multimap<KafkaSession, KafkaMessageProducer> producers = HashMultimap.create();

    ClientState() {
    }

    public void close() throws JMSException {
        log.trace("close() - Closing all consumers.");
        for (MessageConsumer consumer : this.consumers.values()) {
            log.trace("close() - Closing {}", (Object)consumer);
            consumer.close();
        }
        log.trace("close() - Closing all producers.");
        for (MessageProducer producer : this.producers.values()) {
            log.trace("close() - Closing {}", (Object)producer);
            producer.close();
        }
    }

    public void close(KafkaSession session) throws JMSException {
        Collection sessionProducers;
        Collection sessionConsumers = this.consumers.get((Object)session);
        if (null != sessionConsumers && !sessionConsumers.isEmpty()) {
            log.trace("close(Session) - Closing {} consumer(s) for {}.", (Object)sessionConsumers.size(), (Object)session);
            for (MessageConsumer consumer : sessionConsumers) {
                log.trace("close(Session) - Closing {}", (Object)consumer);
                consumer.close();
            }
        }
        if (null != (sessionProducers = this.producers.get((Object)session)) && !sessionProducers.isEmpty()) {
            log.trace("close(Session) - Closing {} producer(s) for {}.", (Object)sessionProducers.size(), (Object)session);
            for (MessageProducer producer : sessionProducers) {
                log.trace("close(Session) - Closing {}", (Object)producer);
                producer.close();
            }
        }
    }

    public Collection<KafkaMessageProducer> producers(KafkaSession session) {
        return this.producers.get((Object)session);
    }

    public Collection<KafkaMessageConsumer> consumers(KafkaSession session) {
        return this.consumers.get((Object)session);
    }

    public void register(KafkaSession session, KafkaMessageConsumer consumer) {
        this.consumers.put((Object)session, (Object)consumer);
    }

    public void register(KafkaSession session, KafkaMessageProducer producer) {
        this.producers.put((Object)session, (Object)producer);
    }
}

