/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.s3.util;

import io.confluent.connect.storage.partitioner.TimeBasedPartitioner;
import io.confluent.connect.storage.partitioner.TimestampExtractor;
import java.util.Map;
import org.apache.kafka.connect.connector.ConnectRecord;

public class TombstoneTimestampExtractor
implements TimestampExtractor {
    private final TimestampExtractor delegateTimestampExtractor;
    private static final TimestampExtractor recordTimestampExtractor = new TimeBasedPartitioner.RecordTimestampExtractor();

    public TombstoneTimestampExtractor(TimestampExtractor delegateTimestampExtractor) {
        this.delegateTimestampExtractor = delegateTimestampExtractor;
    }

    public void configure(Map<String, Object> map) {
        this.delegateTimestampExtractor.configure(map);
        recordTimestampExtractor.configure(map);
    }

    public Long extract(ConnectRecord<?> connectRecord) {
        if (connectRecord.value() == null) {
            return recordTimestampExtractor.extract(connectRecord);
        }
        return this.delegateTimestampExtractor.extract(connectRecord);
    }
}

