/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.s3.util;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.retry.PredefinedRetryPolicies;
import java.io.IOException;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.errors.RetriableException;

public class S3ErrorUtils {
    private static boolean isRetriableException(Throwable exception) {
        if (exception == null) {
            return false;
        }
        for (Throwable cause : ExceptionUtils.getThrowableList((Throwable)exception)) {
            if (cause instanceof AmazonClientException) {
                return PredefinedRetryPolicies.DEFAULT_RETRY_CONDITION.shouldRetry(AmazonWebServiceRequest.NOOP, (AmazonClientException)cause, Integer.MAX_VALUE);
            }
            if (cause instanceof IOException) continue;
            return false;
        }
        return false;
    }

    public static void throwConnectException(Throwable t) throws ConnectException {
        if (t instanceof ConnectException) {
            throw (ConnectException)t;
        }
        if (S3ErrorUtils.isRetriableException(t)) {
            throw new RetriableException(t.getMessage(), t);
        }
        throw new ConnectException(t.getMessage(), t);
    }
}

