/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.s3.format.json;

import io.confluent.connect.s3.S3SinkConnectorConfig;
import io.confluent.connect.s3.format.json.JsonRecordWriterProvider;
import io.confluent.connect.s3.storage.S3Storage;
import io.confluent.connect.storage.format.Format;
import io.confluent.connect.storage.format.RecordWriterProvider;
import io.confluent.connect.storage.format.SchemaFileReader;
import java.util.HashMap;
import org.apache.kafka.connect.json.JsonConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonFormat
implements Format<S3SinkConnectorConfig, String> {
    private static final Logger log = LoggerFactory.getLogger(JsonFormat.class);
    private final S3Storage storage;
    private final JsonConverter converter;

    public JsonFormat(S3Storage storage) {
        this.storage = storage;
        this.converter = new JsonConverter();
        HashMap<String, String> converterConfig = new HashMap<String, String>();
        converterConfig.put("schemas.enable", "false");
        converterConfig.put("schemas.cache.size", String.valueOf(storage.conf().get("schemas.cache.config")));
        converterConfig.put("decimal.format", String.valueOf(storage.conf().getJsonDecimalFormat()));
        this.converter.configure(converterConfig, false);
    }

    public RecordWriterProvider<S3SinkConnectorConfig> getRecordWriterProvider() {
        return new JsonRecordWriterProvider(this.storage, this.converter);
    }

    public SchemaFileReader<S3SinkConnectorConfig, String> getSchemaFileReader() {
        log.debug("Reading schemas from S3 is not currently supported");
        throw new UnsupportedOperationException("Reading schemas from S3 is not currently supported");
    }

    @Deprecated
    public Object getHiveFactory() {
        log.debug("Hive integration is not currently supported in S3 Connector");
        throw new UnsupportedOperationException("Hive integration is not currently supported in S3 Connector");
    }
}

