/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.s3.format.avro;

import io.confluent.connect.avro.AvroData;
import io.confluent.connect.s3.S3SinkConnectorConfig;
import io.confluent.connect.s3.format.RecordViewSetter;
import io.confluent.connect.s3.format.S3RetriableRecordWriter;
import io.confluent.connect.s3.format.avro.AvroFormat;
import io.confluent.connect.s3.storage.IORecordWriter;
import io.confluent.connect.s3.storage.S3OutputStream;
import io.confluent.connect.s3.storage.S3Storage;
import io.confluent.connect.s3.util.Utils;
import io.confluent.connect.storage.format.RecordWriter;
import io.confluent.connect.storage.format.RecordWriterProvider;
import io.confluent.kafka.serializers.NonRecordContainer;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.kafka.connect.sink.SinkRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroRecordWriterProvider
extends RecordViewSetter
implements RecordWriterProvider<S3SinkConnectorConfig> {
    private static final Logger log = LoggerFactory.getLogger(AvroRecordWriterProvider.class);
    private static final String EXTENSION = ".avro";
    private final S3Storage storage;
    private final AvroData avroData;

    AvroRecordWriterProvider(S3Storage storage, AvroData avroData) {
        this.storage = storage;
        this.avroData = avroData;
    }

    public String getExtension() {
        return EXTENSION;
    }

    public RecordWriter getRecordWriter(final S3SinkConnectorConfig conf, final String filename) {
        return new S3RetriableRecordWriter(new IORecordWriter(){
            final String adjustedFilename;
            final DataFileWriter<Object> writer;
            org.apache.kafka.connect.data.Schema schema;
            S3OutputStream s3out;
            private boolean isWriterOpen;
            {
                this.adjustedFilename = Utils.getAdjustedFilename(AvroRecordWriterProvider.this.recordView, filename, AvroRecordWriterProvider.this.getExtension());
                this.writer = new DataFileWriter((DatumWriter)new GenericDatumWriter());
                this.schema = null;
            }

            private void openWriter() {
                this.isWriterOpen = true;
            }

            private void closeWriter() throws IOException {
                this.writer.close();
                this.isWriterOpen = false;
            }

            private boolean isWriterOpen() {
                return this.isWriterOpen;
            }

            @Override
            public void write(SinkRecord record) throws IOException {
                if (!this.isWriterOpen()) {
                    this.schema = AvroRecordWriterProvider.this.recordView.getViewSchema(record, false);
                    log.info("Opening record writer for: {}", (Object)this.adjustedFilename);
                    this.s3out = AvroRecordWriterProvider.this.storage.create(this.adjustedFilename, true, AvroFormat.class);
                    Schema avroSchema = AvroRecordWriterProvider.this.avroData.fromConnectSchema(this.schema);
                    this.writer.setCodec(CodecFactory.fromString((String)conf.getAvroCodec()));
                    this.writer.create(avroSchema, (OutputStream)((Object)this.s3out));
                    this.openWriter();
                }
                log.trace("Sink record with view {}: {}", (Object)AvroRecordWriterProvider.this.recordView, (Object)Utils.sinkRecordToLoggableString(record));
                Object value = AvroRecordWriterProvider.this.avroData.fromConnectData(this.schema, AvroRecordWriterProvider.this.recordView.getView(record, false));
                if (value instanceof NonRecordContainer) {
                    value = ((NonRecordContainer)value).getValue();
                }
                this.writer.append(value);
            }

            @Override
            public void commit() throws IOException {
                this.writer.flush();
                this.s3out.commit();
                this.closeWriter();
            }

            @Override
            public void close() throws IOException {
                this.closeWriter();
            }
        });
    }
}

