/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.json;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.json.DecimalFormat;

public class JsonSchemaDataConfig
extends AbstractConfig {
    public static final String GENERALIZED_SUM_TYPE_SUPPORT_CONFIG = "generalized.sum.type.support";
    public static final boolean GENERALIZED_SUM_TYPE_SUPPORT_DEFAULT = false;
    public static final String GENERALIZED_SUM_TYPE_SUPPORT_DOC = "Toggle for enabling/disabling generalized sum type support: interoperability of enum/union with other schema formats";
    public static final String OBJECT_ADDITIONAL_PROPERTIES_CONFIG = "object.additional.properties";
    public static final boolean OBJECT_ADDITIONAL_PROPERTIES_DEFAULT = true;
    public static final String OBJECT_ADDITIONAL_PROPERTIES_DOC = "Whether to allow additional properties for object schemas.";
    public static final String USE_OPTIONAL_FOR_NON_REQUIRED_CONFIG = "use.optional.for.nonrequired";
    public static final boolean USE_OPTIONAL_FOR_NON_REQUIRED_DEFAULT = false;
    public static final String USE_OPTIONAL_FOR_NON_REQUIRED_DOC = "Whether to set non-required properties to be optional.";
    public static final String SCHEMAS_CACHE_SIZE_CONFIG = "schemas.cache.size";
    public static final int SCHEMAS_CACHE_SIZE_DEFAULT = 1000;
    public static final String SCHEMAS_CACHE_SIZE_DOC = "Size of the converted schemas cache";
    public static final String DECIMAL_FORMAT_CONFIG = "decimal.format";
    public static final String DECIMAL_FORMAT_DEFAULT = DecimalFormat.BASE64.name();
    private static final String DECIMAL_FORMAT_DOC = "Controls which format this converter will serialize decimals in. This value is case insensitive and can be either 'BASE64' (default) or 'NUMERIC'";

    public static ConfigDef baseConfigDef() {
        return new ConfigDef().define(GENERALIZED_SUM_TYPE_SUPPORT_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, GENERALIZED_SUM_TYPE_SUPPORT_DOC).define(OBJECT_ADDITIONAL_PROPERTIES_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.MEDIUM, OBJECT_ADDITIONAL_PROPERTIES_DOC).define(USE_OPTIONAL_FOR_NON_REQUIRED_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, USE_OPTIONAL_FOR_NON_REQUIRED_DOC).define(SCHEMAS_CACHE_SIZE_CONFIG, ConfigDef.Type.INT, (Object)1000, ConfigDef.Importance.LOW, SCHEMAS_CACHE_SIZE_DOC).define(DECIMAL_FORMAT_CONFIG, ConfigDef.Type.STRING, (Object)DECIMAL_FORMAT_DEFAULT, (ConfigDef.Validator)CaseInsensitiveValidString.in(DecimalFormat.BASE64.name(), DecimalFormat.NUMERIC.name()), ConfigDef.Importance.LOW, DECIMAL_FORMAT_DOC);
    }

    public JsonSchemaDataConfig(Map<?, ?> props) {
        super(JsonSchemaDataConfig.baseConfigDef(), props);
    }

    public boolean isGeneralizedSumTypeSupport() {
        return this.getBoolean(GENERALIZED_SUM_TYPE_SUPPORT_CONFIG);
    }

    public boolean allowAdditionalProperties() {
        return this.getBoolean(OBJECT_ADDITIONAL_PROPERTIES_CONFIG);
    }

    public boolean useOptionalForNonRequiredProperties() {
        return this.getBoolean(USE_OPTIONAL_FOR_NON_REQUIRED_CONFIG);
    }

    public int schemaCacheSize() {
        return Math.max(1, this.getInt(SCHEMAS_CACHE_SIZE_CONFIG));
    }

    public DecimalFormat decimalFormat() {
        return DecimalFormat.valueOf((String)this.getString(DECIMAL_FORMAT_CONFIG).toUpperCase(Locale.ROOT));
    }

    public static class CaseInsensitiveValidString
    implements ConfigDef.Validator {
        final Set<String> validStrings;

        private CaseInsensitiveValidString(List<String> validStrings) {
            this.validStrings = validStrings.stream().map(s -> s.toUpperCase(Locale.ROOT)).collect(Collectors.toSet());
        }

        public static CaseInsensitiveValidString in(String ... validStrings) {
            return new CaseInsensitiveValidString(Arrays.asList(validStrings));
        }

        public void ensureValid(String name, Object o) {
            String s = (String)o;
            if (s == null || !this.validStrings.contains(s.toUpperCase(Locale.ROOT))) {
                throw new ConfigException(name, o, "String must be one of (case insensitive): " + Utils.join(this.validStrings, (String)", "));
            }
        }

        public String toString() {
            return "(case insensitive) [" + Utils.join(this.validStrings, (String)", ") + "]";
        }
    }

    public static class Builder {
        private final Map<String, Object> props = new HashMap<String, Object>();

        public Builder with(String key, Object value) {
            this.props.put(key, value);
            return this;
        }

        public JsonSchemaDataConfig build() {
            return new JsonSchemaDataConfig(this.props);
        }
    }
}

