/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.tools;

import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.MessageFormatter;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;

public class ProvenanceHeaderFormatter
implements MessageFormatter {
    public void writeTo(ConsumerRecord<byte[], byte[]> consumerRecord, PrintStream output) {
        boolean found = false;
        Headers headers = consumerRecord.headers();
        for (Header header : headers) {
            if (!"__replicator_id".equals(header.key())) continue;
            if (found) {
                output.print(";");
            }
            output.print(new String(header.value(), StandardCharsets.UTF_8));
            found = true;
        }
        if (found) {
            output.print("\n");
        }
    }

    public void close() {
    }
}

