/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.schemas;

import io.confluent.connect.replicator.schemas.SubjectTranslator;
import io.confluent.connect.replicator.util.Utils;
import java.util.Map;

public class DefaultSubjectTranslator
implements SubjectTranslator {
    private static final String KEY_SUFFIX = "-key";
    private static final String VALUE_SUFFIX = "-value";
    private Map<String, ?> configs;

    @Override
    public void configure(Map<String, ?> configs) {
        this.configs = configs;
    }

    @Override
    public String translate(String subject) {
        if (subject == null) {
            return subject;
        }
        String result = this.tryTranslateWithSuffix(subject, KEY_SUFFIX);
        if (result != null) {
            return result;
        }
        result = this.tryTranslateWithSuffix(subject, VALUE_SUFFIX);
        if (result != null) {
            return result;
        }
        return subject;
    }

    private String tryTranslateWithSuffix(String subject, String suffix) {
        String sourceTopic = subject;
        if (subject.endsWith(suffix)) {
            sourceTopic = sourceTopic.substring(0, sourceTopic.length() - suffix.length());
            return this.toDestTopic(sourceTopic) + suffix;
        }
        return null;
    }

    private String toDestTopic(String sourceTopic) {
        return Utils.renameTopic((String)((String)this.configs.get("topic.rename.format")), (String)sourceTopic);
    }
}

