/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.metrics;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.common.MetricNameTemplate;
import org.apache.kafka.common.metrics.Sensor;

public class ConfluentReplicatorMetricsRegistry {
    static final String CONFLUENT_REPLICATOR_TAG_NAME = "confluent-replicator-name";
    static final String CONFLUENT_REPLICATOR_TOPIC_TAG_NAME = "confluent-replicator-topic-name";
    static final String CONFLUENT_REPLICATOR_TASK_TAG_NAME = "confluent-replicator-task";
    static final String CONFLUENT_REPLICATOR_TASK_TOPIC_PARTITION_TAG_NAME = "confluent-replicator-task-topic-partition";
    static final String CONFLUENT_REPLICATOR_TASK_GROUP_NAME = "confluent-replicator-task-metrics";
    public static final int CONFLUENT_REPLICATOR_METRICS_NUM_SAMPLES = 10;
    public static final long CONFLUENT_REPLICATOR_METRICS_SAMPLE_WINDOW_MS = 10000L;
    static final Sensor.RecordingLevel CONFLUENT_REPLICATOR_METRICS_RECORDING_LEVEL = Sensor.RecordingLevel.INFO;
    private static final String SOURCE_CLUSTER_ID = "confluent-replicator-source-cluster";
    private static final String SOURCE_CLUSTER_ID_DOC = "The id of the source cluster";
    private static final String DEST_CLUSTER_ID = "confluent-replicator-destination-cluster";
    private static final String DEST_CLUSTER_ID_DOC = "The id of the destination cluster";
    private static final String DEST_TOPIC_NAME = "confluent-replicator-destination-topic-name";
    private static final String DEST_TOPIC_NAME_DOC = "The name of the topic that data is being replicated to in the destination cluster";
    public static final String REPLICATOR_TASK_MESSAGE_LAG = "confluent-replicator-task-topic-partition-message-lag";
    private static final String REPLICATOR_TASK_MESSAGE_LAG_DOC = "The number of messages the destination cluster is behind the source cluster";
    public static final String REPLICATOR_TASK_LATENCY = "confluent-replicator-task-topic-partition-latency";
    private static final String REPLICATOR_TASK_LATENCY_DOC = "The amount of time it takes for a message written to the source cluster to be written by this task to the destination cluster";
    public static final String REPLICATOR_TASK_THROUGHPUT = "confluent-replicator-task-topic-partition-throughput";
    private static final String REPLICATOR_TASK_THROUGHPUT_DOC = "The rate at which messages are being written by this task";
    public static final String REPLICATOR_TASK_BYTE_THROUGHPUT = "confluent-replicator-task-topic-partition-byte-throughput";
    private static final String REPLICATOR_TASK_BYTE_THROUGHPUT_DOC = "The rate (in bytes) at which data is being written by this task";
    static final String REPLICATOR_TASK_SENSOR_PREFIX = "confluent-replicator-sensor-group: ";
    static final String REPLICATOR_END_OFFSETS_CONSUMER_NAME = "confluent-replicator-end-offsets-consumer-group";
    static final String REPLICATOR_END_OFFSETS_CONSUMER_CLIENT_ID = "confluent-replicator-end-offsets-consumer-client";
    public static final Set<String> CONFLUENT_REPLICATOR_TASK_TAGS = new HashSet<String>(Arrays.asList("confluent-replicator-task", "confluent-replicator-task-topic-partition", "confluent-replicator-topic-name", "confluent-replicator-name"));
    public static final MetricNameTemplate sourceClusterIdTemplate = ConfluentReplicatorMetricsRegistry.createTemplate("confluent-replicator-source-cluster", "The id of the source cluster");
    public static final MetricNameTemplate destClusterIdTemplate = ConfluentReplicatorMetricsRegistry.createTemplate("confluent-replicator-destination-cluster", "The id of the destination cluster");
    public static final MetricNameTemplate destTopic = ConfluentReplicatorMetricsRegistry.createTemplate("confluent-replicator-destination-topic-name", "The name of the topic that data is being replicated to in the destination cluster");
    public static final MetricNameTemplate replicatorTaskMessageLagTemplate = ConfluentReplicatorMetricsRegistry.createTemplate("confluent-replicator-task-topic-partition-message-lag", "The number of messages the destination cluster is behind the source cluster");
    public static final MetricNameTemplate replicatorTaskLatencyTemplate = ConfluentReplicatorMetricsRegistry.createTemplate("confluent-replicator-task-topic-partition-latency", "The amount of time it takes for a message written to the source cluster to be written by this task to the destination cluster");
    public static final MetricNameTemplate replicatorTaskThroughputTemplate = ConfluentReplicatorMetricsRegistry.createTemplate("confluent-replicator-task-topic-partition-throughput", "The rate at which messages are being written by this task");
    public static final MetricNameTemplate replicatorTaskByteThroughputTemplate = ConfluentReplicatorMetricsRegistry.createTemplate("confluent-replicator-task-topic-partition-byte-throughput", "The rate (in bytes) at which data is being written by this task");

    private static MetricNameTemplate createTemplate(String name, String doc) {
        return new MetricNameTemplate(name, CONFLUENT_REPLICATOR_TASK_GROUP_NAME, doc, CONFLUENT_REPLICATOR_TASK_TAGS);
    }
}

