/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.metrics;

import io.confluent.connect.replicator.metrics.ConfluentReplicatorMetricsRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.MetricNameTemplate;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.JmxReporter;
import org.apache.kafka.common.metrics.KafkaMetricsContext;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.connect.runtime.ConnectMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluentReplicatorMetrics {
    public static final String JMX_PREFIX = "confluent.replicator";
    private static final Logger log = LoggerFactory.getLogger(ConfluentReplicatorMetrics.class);
    private final Metrics metrics;
    private final Time time;
    private final String taskId;
    private final ConcurrentMap<ConnectMetrics.MetricGroupId, ReplicatorMetricGroup> groupsByName = new ConcurrentHashMap<ConnectMetrics.MetricGroupId, ReplicatorMetricGroup>();

    public ConfluentReplicatorMetrics(String taskId, Time time) {
        this.taskId = taskId;
        this.time = time;
        ArrayList<JmxReporter> reporters = new ArrayList<JmxReporter>();
        JmxReporter reporter = new JmxReporter();
        KafkaMetricsContext metricsContext = new KafkaMetricsContext(JMX_PREFIX);
        reporter.contextChange((MetricsContext)metricsContext);
        reporters.add(reporter);
        log.info("Registering Confluent Replicator metrics with JMX for task '{}'", (Object)taskId);
        MetricConfig metricConfig = new MetricConfig().samples(10).timeWindow(10000L, TimeUnit.MILLISECONDS).recordLevel(ConfluentReplicatorMetricsRegistry.CONFLUENT_REPLICATOR_METRICS_RECORDING_LEVEL);
        this.metrics = new Metrics(metricConfig, reporters, time, (MetricsContext)metricsContext);
        log.info("Successfully registered Confluent Replicator metrics with JMX for task '{}'", (Object)taskId);
    }

    public Time time() {
        return this.time;
    }

    public void stop() {
        log.info("Unregistering Confluent Replicator metrics with JMX for task '{}'", (Object)this.taskId);
        this.metrics.close();
    }

    public ReplicatorMetricGroup group(String groupName, String ... tagKeyValues) {
        ReplicatorMetricGroup previous;
        ConnectMetrics.MetricGroupId groupId = this.groupId(groupName, tagKeyValues);
        ReplicatorMetricGroup group = (ReplicatorMetricGroup)this.groupsByName.get(groupId);
        if (group == null && (previous = this.groupsByName.putIfAbsent(groupId, group = new ReplicatorMetricGroup(groupId))) != null) {
            group = previous;
        }
        return group;
    }

    protected ConnectMetrics.MetricGroupId groupId(String groupName, String ... tagKeyValues) {
        Map<String, String> tags = this.tags(tagKeyValues);
        return new ConnectMetrics.MetricGroupId(groupName, tags);
    }

    private Map<String, String> tags(String ... keyValue) {
        if (keyValue.length % 2 != 0) {
            throw new IllegalArgumentException("keyValue needs to be specified in pairs");
        }
        LinkedHashMap<String, String> tags = new LinkedHashMap<String, String>();
        for (int i = 0; i < keyValue.length; i += 2) {
            tags.put(keyValue[i], keyValue[i + 1]);
        }
        return tags;
    }

    public class ReplicatorMetricGroup
    implements AutoCloseable {
        public final ConnectMetrics.MetricGroupId groupId;
        private Map<String, Sensor> sensorMap;
        public final String sensorPrefix;

        ReplicatorMetricGroup(ConnectMetrics.MetricGroupId groupId) {
            Objects.requireNonNull(groupId);
            this.groupId = groupId;
            this.sensorPrefix = "confluent-replicator-sensor-group: " + groupId.toString() + ";";
            this.sensorMap = new HashMap<String, Sensor>();
        }

        public void recordMetrics(String sensorName, double value) {
            Sensor sensor = this.sensorMap.get(sensorName);
            if (sensor != null) {
                sensor.record(value);
            }
        }

        public Metrics metrics() {
            return ConfluentReplicatorMetrics.this.metrics;
        }

        public MetricName metricName(MetricNameTemplate template) {
            return ConfluentReplicatorMetrics.this.metrics.metricInstance(template, this.groupId.tags());
        }

        synchronized Sensor sensor(String name) {
            Sensor sensor = ConfluentReplicatorMetrics.this.metrics.sensor(this.sensorPrefix + name);
            this.sensorMap.put(sensor.name(), sensor);
            return sensor;
        }

        public Set<String> getSensorNames() {
            return this.sensorMap.keySet();
        }

        <T> void addImmutableValueMetric(MetricNameTemplate nameTemplate, T value) {
            MetricName metricName = this.metricName(nameTemplate);
            if (this.metrics().metric(metricName) == null) {
                this.metrics().addMetric(metricName, (MetricValueProvider)((Gauge)(config, now) -> value));
            }
        }

        @Override
        public synchronized void close() {
            for (String sensor : this.sensorMap.keySet()) {
                ConfluentReplicatorMetrics.this.metrics.removeSensor(sensor);
            }
            this.sensorMap.clear();
            for (MetricName metricName : new HashSet(ConfluentReplicatorMetrics.this.metrics.metrics().keySet())) {
                if (!this.groupId.includes(metricName)) continue;
                ConfluentReplicatorMetrics.this.metrics.removeMetric(metricName);
            }
        }
    }
}

