/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.exec;

import io.airlift.airline.Command;
import io.airlift.airline.Help;
import io.airlift.airline.HelpOption;
import io.airlift.airline.Option;
import io.airlift.airline.ParseArgumentsUnexpectedException;
import io.airlift.airline.ParseOptionMissingException;
import io.airlift.airline.SingleCommand;
import io.airlift.airline.model.CommandMetadata;
import io.airlift.airline.model.OptionMetadata;
import io.confluent.connect.replicator.KafkaConfigs;
import io.confluent.connect.replicator.ReplicatorSourceConnector;
import io.confluent.connect.replicator.util.ByteArrayConverter;
import io.confluent.license.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.runtime.WorkerInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Command(name="replicator", description="Replicator by Confluent.")
public class ReplicatorCli {
    private static final Logger log = LoggerFactory.getLogger(ReplicatorCli.class);
    private static final String COMMAND_NAME = "replicator";
    private final Map<String, String> allProps = new HashMap<String, String>();
    private final SingleCommand<ReplicatorCli> cmd = SingleCommand.singleCommand(ReplicatorCli.class);
    private final Map<String, OptionMetadata> options = new HashMap<String, OptionMetadata>();
    private static final List<String> WARN_ON_DEFAULTS = Arrays.asList("offset.storage.topic", "status.storage.topic", "config.storage.topic");
    private static final List<String> REPLICATION_CONFIG_BLACKLIST_PREFIXES = Arrays.asList("src.consumer.", KafkaConfigs.KafkaCluster.SOURCE.prefix(), KafkaConfigs.KafkaCluster.DESTINATION.prefix());
    @Inject
    public HelpOption helpOption;
    @Option(name={"--cluster.id"}, title="Replicator Cluster Id", description="Specifies the unique identifier for the Replicator cluster.", required=true)
    public String clusterId;
    @Option(name={"--producer.config"}, title="producer.properties", description="Specifies the location of the file that contains the configuration settings for the producer writing to the destination cluster.", required=true)
    public String producerConfig;
    @Option(name={"--consumer.config"}, title="consumer.properties", description="Specifies the location of the file that contains the configuration settings for the consumer reading from the origin cluster.", required=true)
    public String consumerConfig;
    @Option(name={"--replication.config"}, title="replication.properties", description="Specifies the location of the file that contains the configuration settings for replication. When used, any property in this file can be overridden via a command line parameter. When this is not supplied, all of the properties defining how topics are to be replicated should be specified on the command line.")
    public String replicationConfig = "";
    @Option(name={"--producer.monitoring.config"}, title="producer-monitoring.properties", description="Specifies the location of the file that contains the producer settings for the Kafka cluster where monitoring information about the Replicator producer is to be sent. This must be specified if monitoring is to be enabled, but may point to a different Kafka cluster than the origin or destination clusters. Use the same file as --producer-config to write metrics to the destination cluster.")
    public String producerMonitoringConfig = "";
    @Option(name={"--consumer.monitoring.config"}, title="consumer-monitoring.properties", description="Specifies the location of the file that contains the producer settings for the Kafka cluster where monitoring information about the Replicator consumer is to be sent. This must be specified if monitoring is to be enabled, but may point to a different Kafka cluster than the origin or destination clusters. Use the same file as `--producer-config` to write metrics to the destination cluster.")
    public String consumerMonitoringConfig = "";
    @Option(name={"--cluster.threads"}, title="Total Replicator threads", description="The total number of threads across all workers in the Replicator cluster. If this command starts another Replicator worker in an existing cluster, this can be used to change the number of threads in the whole cluster.")
    public Integer clusterThreads;
    @Option(name={"--confluent.license"}, title="Confluent License Key", description="Your Confluent license key that enables you to use Replicator. Without the license key, you can use Replicator for a 30-day trial period. If you are a subscriber, please contact Confluent Support for more information.")
    public String confluentLicense;
    @Option(name={"--topic.regex"}, title="Regular Expression to Match Topics for Replication", description="A regular expression that matches the names of the topics to be replicated. Any topic that matches this expression (or is listed in the whitelist) and not in the blacklist will be replicated.")
    public String topicRegex;
    @Option(name={"--whitelist"}, title="Topic Whitelist", description="A comma-separated list of the names of topics that should be replicated. Any topic that is in this list and not in the blacklist will be replicated.")
    public String whitelist;
    @Option(name={"--blacklist"}, title="Topic Blacklist", description="A comma-separated list of topics that should not be replicated, even if they are included in the whitelist or matched by the regular expression.")
    public String blacklist;
    @Option(name={"--topic.rename.format"}, title="Rename Format", description="A format string for the topic name in the destination cluster, which may contain ${topic} as a placeholder for the originating topic name. For example, ${topic}_dc1 for the topic 'orders' will map to the destination topic name 'orders_dc1.' Can be placed inside the file specified by --replication.config.")
    public String topicRenameFormat;
    @Option(name={"--topic.auto.create"}, title="Auto-create Topics on Destination", description="Whether to automatically create topics in the destination cluster if required.", arity=1)
    public Boolean topicAutoCreate;
    @Option(name={"--topic.preserve.partitions"}, title="Auto-create Topics on Destination", description="Whether to automatically increase the number of partitions in the destination cluster to match the source cluster and ensure that messages replicated from the source cluster use the same partition in the destination cluster.", arity=1)
    public Boolean topicPreservePartitions;
    @Option(name={"--topic.config.sync"}, title="Sync Topic Configs", description="Whether to periodically sync topic configuration to the destination cluster.", arity=1)
    public Boolean topicConfigSync;
    @Option(name={"--topic.timestamp.type"}, title="Topic Timestamp Type", description="The timestamp type for the topics in the destination cluster.")
    public Long topicTimestampType;
    @Option(name={"--topic.poll.interval.ms"}, title="Topic Config Sync Interval (ms)", description="Specifies how frequently to poll the source cluster for new topics matching the whitelist or regular expression. Can also be read from the file given by --replication.config.")
    public Long topicPollIntervalMs;
    @Option(name={"--topic.create.backoff.ms"}, title="Topic Creation Backoff (ms)", description="Time to wait before retrying auto topic creation or expansion.")
    public Long topicCreateBackoffMs;
    @Option(name={"--topic.config.sync.interval.ms"}, title="Topic Config Sync Interval (ms)", description="How often to check for configuration changes when 'topic.config.sync' is enabled.", allowedValues={"CreateTime", "LogAppendTime"})
    public Long topicConfigSyncIntervalMs;

    public ReplicatorCli() {
        for (OptionMetadata meta : this.cmd.getCommandMetadata().getAllOptions()) {
            for (String name : meta.getOptions()) {
                this.options.put(name, meta);
            }
        }
    }

    public Map<String, String> parse(String[] args) {
        try {
            ReplicatorCli cli = (ReplicatorCli)this.cmd.parse(args);
            if (cli.helpOption.showHelpIfRequested()) {
                Exit.exit((int)0);
            }
            return cli.validate();
        }
        catch (ParseArgumentsUnexpectedException | ParseOptionMissingException pe) {
            log.error(pe.getMessage());
            try {
                Help.help((CommandMetadata)this.cmd.getCommandMetadata());
            }
            catch (Exception e) {
                log.error("Unable to print usage: ", (Throwable)e);
            }
            Exit.exit((int)1);
        }
        catch (Exception e) {
            log.error("Error running {}", (Object)COMMAND_NAME, (Object)e);
            Exit.exit((int)1);
        }
        return Collections.emptyMap();
    }

    public Map<String, String> validate() {
        log.info("Kafka Connect distributed worker initializing ...");
        WorkerInfo initInfo = new WorkerInfo();
        initInfo.logAll();
        this.warnOnDefaults(this.producerConfig, this.consumerConfig, this.replicationConfig);
        this.errorOnBlacklistConfig(this.replicationConfig);
        this.allProps.clear();
        this.loadRequiredDefaults();
        this.allProps.putAll(this.parseAndValidatePropsFile(this.producerConfig, "producer."));
        this.allProps.putAll(this.parseAndValidatePropsFile(this.consumerConfig, "src.consumer."));
        this.allProps.putAll(this.parseAndValidatePropsFile(this.producerMonitoringConfig, "producer.confluent.monitoring.interceptor."));
        this.allProps.putAll(this.parseAndValidatePropsFile(this.consumerMonitoringConfig, "consumer.confluent.monitoring.interceptor."));
        Map<String, String> withoutInterceptorProps = this.extractAndLoadProperties("producer.", "");
        ReplicatorSourceConnector.filterOutInterceptorPropertiesInPlace(withoutInterceptorProps);
        this.allProps.putAll(withoutInterceptorProps);
        this.allProps.putAll(ReplicatorSourceConnector.filterOutInterceptorPropertiesInPlace(this.extractAndLoadProperties("producer.", KafkaConfigs.KafkaCluster.DESTINATION.prefix())));
        this.allProps.putAll(ReplicatorSourceConnector.filterOutInterceptorPropertiesInPlace(this.extractAndLoadProperties("src.consumer.", KafkaConfigs.KafkaCluster.SOURCE.prefix())));
        this.allProps.putAll(this.parseAndValidatePropsFile(this.replicationConfig));
        this.allProps.putIfAbsent("connect.protocol", "eager");
        this.parseAndValidateSingularCommandLineOptions();
        return this.allProps;
    }

    private void errorOnBlacklistConfig(String replicationConfig) {
        ArrayList<String> foundBlackListedConfigs = new ArrayList<String>();
        for (String key : this.parseAndValidatePropsFile(replicationConfig).keySet()) {
            for (String blacklistPrefix : REPLICATION_CONFIG_BLACKLIST_PREFIXES) {
                if (!key.startsWith(blacklistPrefix)) continue;
                foundBlackListedConfigs.add(key);
            }
        }
        if (!foundBlackListedConfigs.isEmpty()) {
            throw new InvalidConfigurationException("The following invalid configurations were found in " + replicationConfig + ": " + foundBlackListedConfigs + ". These configurations should be provided in --consumer.config and --producer.config instead.");
        }
    }

    private void warnOnDefaults(String ... propertiesFiles) {
        for (String warnConfig : WARN_ON_DEFAULTS) {
            boolean willWarn = true;
            for (String propertiesFile : propertiesFiles) {
                if (!this.parseAndValidatePropsFile(propertiesFile, "").containsKey(warnConfig)) continue;
                willWarn = false;
            }
            if (!willWarn) continue;
            log.warn("Property: " + warnConfig + " is configured to it's default value. Please consider overriding this to avoid conflicts between replicator instances.");
        }
    }

    protected Map<String, String> parseAndValidatePropsFile(String filename) {
        return this.parseAndValidatePropsFile(filename, null);
    }

    protected Map<String, String> parseAndValidatePropsFile(String filename, String prefix) {
        try {
            if (filename.isEmpty()) {
                return Collections.emptyMap();
            }
            Map originalProps = Utils.propsToStringMap((Properties)Utils.loadProps((String)filename));
            if (StringUtils.isNotBlank((String)prefix)) {
                HashMap<String, String> props = new HashMap<String, String>();
                for (Map.Entry entry : originalProps.entrySet()) {
                    props.put(prefix + (String)entry.getKey(), (String)entry.getValue());
                }
                return props;
            }
            return originalProps;
        }
        catch (IOException e) {
            throw new ConnectException("Unable to read properties from file: " + filename);
        }
    }

    protected Map<String, String> extractAndLoadProperties(String currentPrefix, String newPrefix) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : this.allProps.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(currentPrefix)) continue;
            if (StringUtils.isNotBlank((String)newPrefix)) {
                props.put(newPrefix + key.substring(currentPrefix.length()), entry.getValue());
                continue;
            }
            props.put(key.substring(currentPrefix.length()), entry.getValue());
        }
        return props;
    }

    protected void loadRequiredDefaults() {
        ReplicatorCli.maybeOverride("internal.key.converter.schemas.enable", false, this.allProps);
        ReplicatorCli.maybeOverride("internal.value.converter.schemas.enable", false, this.allProps);
        ReplicatorCli.maybeOverride("offset.storage.topic", "connect-offsets", this.allProps);
        ReplicatorCli.maybeOverride("config.storage.topic", "connect-configs", this.allProps);
        ReplicatorCli.maybeOverride("status.storage.topic", "connect-status", this.allProps);
        ReplicatorCli.maybeOverride("name", COMMAND_NAME, this.allProps);
        ReplicatorCli.maybeOverride("connector.class", ReplicatorSourceConnector.class.getName(), this.allProps);
        ReplicatorCli.maybeOverride("header.converter", ByteArrayConverter.class.getName(), this.allProps);
        ReplicatorCli.maybeOverride("key.converter", ByteArrayConverter.class.getName(), this.allProps);
        ReplicatorCli.maybeOverride("value.converter", ByteArrayConverter.class.getName(), this.allProps);
    }

    protected void parseAndValidateSingularCommandLineOptions() {
        this.allProps.put("group.id", this.clusterId);
        ReplicatorCli.maybeOverride("tasks.max", this.clusterThreads, this.allProps);
        ReplicatorCli.maybeOverride("confluent.license", this.confluentLicense, this.allProps);
        ReplicatorCli.maybeOverride("topic.regex", this.topicRegex, this.allProps);
        ReplicatorCli.maybeOverride("topic.whitelist", this.whitelist, this.allProps);
        ReplicatorCli.maybeOverride("topic.blacklist", this.blacklist, this.allProps);
        ReplicatorCli.maybeOverride("topic.rename.format", this.topicRenameFormat, this.allProps);
        ReplicatorCli.maybeOverride("topic.auto.create", this.topicAutoCreate, this.allProps);
        ReplicatorCli.maybeOverride("topic.preserve.partitions", this.topicPreservePartitions, this.allProps);
        ReplicatorCli.maybeOverride("topic.config.sync", this.topicConfigSync, this.allProps);
        ReplicatorCli.maybeOverride("topic.timestamp.type", this.topicTimestampType, this.allProps);
        ReplicatorCli.maybeOverride("topic.poll.interval.ms", this.topicPollIntervalMs, this.allProps);
        ReplicatorCli.maybeOverride("topic.create.backoff.ms", this.topicCreateBackoffMs, this.allProps);
        ReplicatorCli.maybeOverride("topic.config.sync.interval.ms", this.topicConfigSyncIntervalMs, this.allProps);
    }

    private static <T> void maybeOverride(String property, T value, Map<String, String> props) {
        if (value != null) {
            props.put(property, String.valueOf(value));
        }
    }
}

