/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.exec;

import io.confluent.connect.replicator.ReplicatorApp;
import java.util.Map;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.connect.connector.policy.ConnectorClientConfigOverridePolicy;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.Worker;
import org.apache.kafka.connect.runtime.distributed.DistributedConfig;
import org.apache.kafka.connect.runtime.distributed.DistributedHerder;
import org.apache.kafka.connect.runtime.rest.entities.ConnectorInfo;
import org.apache.kafka.connect.runtime.rest.errors.BadRequestException;
import org.apache.kafka.connect.storage.ConfigBackingStore;
import org.apache.kafka.connect.storage.StatusBackingStore;
import org.apache.kafka.connect.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedHerder
extends DistributedHerder
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedHerder.class);
    private final String appInstanceName;

    public EmbeddedHerder(String appInstanceName, DistributedConfig config, Worker worker, String kafkaClusterId, StatusBackingStore statusBackingStore, ConfigBackingStore configBackingStore, String restUrl, Time time, ConnectorClientConfigOverridePolicy overridePolicy) {
        super(config, time, worker, kafkaClusterId, statusBackingStore, configBackingStore, restUrl, overridePolicy, new AutoCloseable[0]);
        this.appInstanceName = appInstanceName;
    }

    public void putConnectorConfig(String connName, Map<String, String> config, boolean allowReplace, Callback<Herder.Created<ConnectorInfo>> callback) {
        if (!this.appInstanceName.equals(connName)) {
            log.warn("Request to update configuration on {} cluster does not match current running instance: '{}' (current) != '{}' (given). You need to use '{}' or reset the config topic on the {} cluster", new Object[]{ReplicatorApp.name(), this.appInstanceName, connName, this.appInstanceName, ReplicatorApp.name()});
            String msg = "Configuration on the " + ReplicatorApp.name() + " cluster can be updated only for the running instance: '" + this.appInstanceName + "'";
            throw new BadRequestException(msg);
        }
        super.putConnectorConfig(connName, config, allowReplace, callback);
    }
}

